/*******************************************************************************
 * Copyright (c) 2006 NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NEC Soft, Ltd.- initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.tablewizard.ui.utils;

import java.util.ResourceBundle;

/**
 * 
 * @author yuanying
 * 
 */
public class ResourceLoader {

	private static final String RESOURCE_PATH = "org/eclipse/datatools/sqltools/tablewizard/ui/l10n/"; //$NON-NLS-1$
	private static final String UI_RESOURCES = "tableUI"; //$NON-NLS-1$
	private static final String NO_RESOURCE_FOUND = "NO_RESOURCE_FOUND"; //$NON-NLS-1$

	private static ResourceBundle BUNDLE = ResourceBundle.getBundle(RESOURCE_PATH + UI_RESOURCES);

	/**
	 * @param stringID -
	 *            the key to look for
	 * @return - the localized string
	 */
	public static String queryString(String stringID) {
		try {
			String resource = null;
			resource = BUNDLE.getString(stringID);
			return (resource);
		} catch (Throwable e) {
			return NO_RESOURCE_FOUND;
		}
	}
}
