/*******************************************************************************
 * Copyright (c) 2006 NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NEC Soft, Ltd.- initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.tablewizard.ui.utils;

import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.emf.ecore.EObject;

/**
 * @author yuanying
 * 
 */
public class TableColumnsPropertyLabelProvider extends
		EObjectListPropertyLabelProvider {

	public TableColumnsPropertyLabelProvider(EObject target, int featureID,
			int[] childFeatureIDs) {
		super(target, featureID, childFeatureIDs);
	}

	public String getColumnText(Object element, int columnIndex) {
		if (element instanceof EObject) {
			EObject obj = (EObject) element;
			if (columnIndex < this.getChildFeatureIDs().length) {
				Object result = obj.eGet(EObjectUtils.computeStructualFeature(
						obj, this.getChildFeatureIDs()[columnIndex]));
				if (result instanceof DataType) {
					result = ((DataType) result).getName();
				}
				return result == null ? "" : result.toString(); //$NON-NLS-1$
			}
		}
		return null;
	}

	public String getText(Object element) {
		Column column = (Column) element;
		// FIXME if columns validation is suppot, remove
		// this code.
		if (column.getDataType() == null) {
			return column.getName();
		}
		return column.getName() + " (" + column.getDataType().getName() + ")"; //$NON-NLS-1$ //$NON-NLS-2$
	}
}
