/*******************************************************************************
 * Copyright (c) 2007 NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NEC Soft, Ltd.- initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.columns.actions;

import java.util.List;

import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesFactory;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.ResourceLoader;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

/**
 * @author yuanying
 *
 */
public class AddColumnAction extends Action implements SelectionListener {
	private static final String NEW_COLUMN_NAME_PREFIX = "new_column.name.prefix"; //$NON-NLS-1$
	
	final private TableViewer columnsViewer;
	final private List columnsList;
	int counter = 0;

	public AddColumnAction(List columnsList, TableViewer columnsViewer) {
		this.setText(ResourceLoader.queryString("column.add_button.label")); //$NON-NLS-1$
		this.columnsList = columnsList;
		this.columnsViewer = columnsViewer;
	}

	public void run() {
		Column column = SQLTablesFactory.eINSTANCE.createColumn();
		// column.setTable(this.table);
		column.setName(ResourceLoader.queryString(NEW_COLUMN_NAME_PREFIX) + this.counter);
//		column.setDefaultValue("");
		this.counter++;
		this.columnsList.add(column);
		this.columnsViewer.setSelection(new StructuredSelection(column));
	}

	public void widgetDefaultSelected(SelectionEvent e) {
	}

	public void widgetSelected(SelectionEvent e) {
		this.run();
	}
}
