/*******************************************************************************
 * Copyright (c) 2007 NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NEC Soft, Ltd.- initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.columns.actions;

import java.util.List;

import org.eclipse.datatools.sqltools.tablewizard.ui.utils.ResourceLoader;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

/**
 * 
 * @author yuanying
 *
 */
public class DeleteColumnAction extends Action implements SelectionListener {
	
	final private List columnList;
	final private ISelectionProvider selectionProvider;
	
	public DeleteColumnAction(List columnList, ISelectionProvider selectionProvider) {
		this.setText(ResourceLoader.queryString("column.delete_button.label")); //$NON-NLS-1$
		this.columnList = columnList;
		this.selectionProvider = selectionProvider;
	}
	
	public void run() {
		ISelection selection = this.selectionProvider.getSelection();
		if (selection.isEmpty()) {
			return;
		}
		if (selection instanceof IStructuredSelection) {
			IStructuredSelection ss = (IStructuredSelection) selection;
			this.columnList.remove(ss.getFirstElement());
		}
	}

	public void widgetDefaultSelected(SelectionEvent e) {
	}

	public void widgetSelected(SelectionEvent e) {
		this.run();
	}
	
}
