/*******************************************************************************
 * Copyright (c) 2006 NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NEC Soft, Ltd.- initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.fk;

import org.eclipse.datatools.sqltools.tablewizard.ui.Messages;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

/**
 * @author yuanying
 *
 */
public class ForeignKeysComposite extends Composite {

	private Composite innerFKComposite = null;
	private List foreignKeyList = null;
	private ListViewer foreignKeyListViewer = null;
	private Button addForeignKeyButton = null;
	private Button deleteForeignKeyButton = null;
	private Group detailFKGroup = null;
	private Composite headDetailComposite = null;
	private Label nameLabel = null;
	private Text fkNameText = null;
	private Label fkNameLabel = null;
	private Combo refTableCombo = null;
	private ComboViewer refTableComboViewer = null;
	private Table fkDetailTable = null;
	private TableViewer fkDetailTableViewer = null;
	private Composite footComposite = null;
	private Button addDetailButton = null;
	private Button deleteDetailButton = null;

	/**
	 * @param arg0
	 * @param arg1
	 */
	public ForeignKeysComposite(Composite arg0, int arg1) {
		super(arg0, arg1);
		initialize();
	}

	public Button getAddDetailButton() {
		return addDetailButton;
	}

	public Button getAddForeignKeyButton() {
		return addForeignKeyButton;
	}

	public Button getDeleteDetailButton() {
		return deleteDetailButton;
	}

	public Button getDeleteForeignKeyButton() {
		return deleteForeignKeyButton;
	}

	public Group getDetailFKGroup() {
		return detailFKGroup;
	}

	public Table getFkDetailTable() {
		return fkDetailTable;
	}

	public TableViewer getFkDetailTableViewer() {
		return fkDetailTableViewer;
	}

	public Text getFkNameText() {
		return fkNameText;
	}

	public Composite getFootComposite() {
		return footComposite;
	}

	public List getForeignKeyList() {
		return foreignKeyList;
	}

	public ListViewer getForeignKeyListViewer() {
		return foreignKeyListViewer;
	}

	public Composite getHeadDetailComposite() {
		return headDetailComposite;
	}

	public Composite getInnerFKComposite() {
		return innerFKComposite;
	}

	public Combo getRefTableCombo() {
		return refTableCombo;
	}

	public ComboViewer getRefTableComboViewer() {
		return refTableComboViewer;
	}

	private void initialize() {
		GridLayout gridLayout1 = new GridLayout();
		gridLayout1.numColumns = 1;
		this.setLayout(gridLayout1);
		createInnerFKComposite();
		createDetailFKGroup();
		setSize(new Point(538, 325));
	}

	/**
	 * This method initializes innerFKComposite	
	 *
	 */
	private void createInnerFKComposite() {
		GridData gridData1 = new GridData();
		gridData1.horizontalSpan = 2;
		gridData1.verticalAlignment = GridData.FILL;
		gridData1.grabExcessVerticalSpace = true;
		gridData1.grabExcessHorizontalSpace = true;
		gridData1.horizontalAlignment = GridData.FILL;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		gridData.grabExcessHorizontalSpace = true;
		gridData.verticalAlignment = GridData.FILL;
		innerFKComposite = new Composite(this, SWT.NONE);
		innerFKComposite.setLayoutData(gridData);
		innerFKComposite.setLayout(gridLayout);
		foreignKeyList = new List(innerFKComposite, SWT.NONE);
		foreignKeyList.setLayoutData(gridData1);
		addForeignKeyButton = new Button(innerFKComposite, SWT.NONE);
		addForeignKeyButton.setText(Messages.getString("ForeignKeysComposite.ForeignKeysComposite.Add")); //$NON-NLS-1$
		deleteForeignKeyButton = new Button(innerFKComposite, SWT.NONE);
		deleteForeignKeyButton.setText(Messages.getString("ForeignKeysComposite.ForeignKeysComposite.Delete")); //$NON-NLS-1$
		foreignKeyListViewer = new ListViewer(foreignKeyList);
	}

	/**
	 * This method initializes detailFKGroup	
	 *
	 */
	private void createDetailFKGroup() {
		GridLayout gridLayout3 = new GridLayout();
		gridLayout3.numColumns = 1;
		GridData gridData3 = new GridData();
		gridData3.horizontalAlignment = GridData.FILL;
		gridData3.grabExcessHorizontalSpace = true;
		gridData3.grabExcessVerticalSpace = true;
		gridData3.verticalAlignment = GridData.FILL;
		GridData gridData2 = new GridData();
		gridData2.horizontalAlignment = GridData.FILL;
		gridData2.grabExcessHorizontalSpace = true;
		gridData2.grabExcessVerticalSpace = true;
		gridData2.verticalAlignment = GridData.FILL;
		detailFKGroup = new Group(this, SWT.NONE);
		detailFKGroup.setText(Messages.getString("ForeignKeysComposite.ForeignKeysComposite.ForeignKeyDetail")); //$NON-NLS-1$
		createHeadDetailComposite();
		detailFKGroup.setLayout(gridLayout3);
		detailFKGroup.setLayoutData(gridData2);
		fkDetailTable = new Table(detailFKGroup, SWT.FULL_SELECTION);
		fkDetailTable.setHeaderVisible(true);
		fkDetailTable.setLayoutData(gridData3);
		fkDetailTable.setLinesVisible(true);
		createFootComposite();
		TableColumn tableColumn = new TableColumn(fkDetailTable, SWT.NONE);
		tableColumn.setWidth(160);
		tableColumn.setText(Messages.getString("ForeignKeysComposite.ForeignKeyComposite.Column")); //$NON-NLS-1$
		TableColumn tableColumn1 = new TableColumn(fkDetailTable, SWT.NONE);
		tableColumn1.setWidth(160);
		tableColumn1.setText(Messages.getString("ForeignKeysComposite.ForeignKeysComposite.ForeignColumn")); //$NON-NLS-1$
		fkDetailTableViewer = new TableViewer(fkDetailTable);
	}

	/**
	 * This method initializes headDetailComposite	
	 *
	 */
	private void createHeadDetailComposite() {
		GridData gridData4 = new GridData();
		gridData4.widthHint = 120;
		GridLayout gridLayout2 = new GridLayout();
		gridLayout2.numColumns = 4;
		headDetailComposite = new Composite(detailFKGroup, SWT.NONE);
		headDetailComposite.setLayout(gridLayout2);
		nameLabel = new Label(headDetailComposite, SWT.NONE);
		nameLabel.setText(Messages.getString("ForeignKeysComposite.ForeignKeysComposite.Name")); //$NON-NLS-1$
		fkNameText = new Text(headDetailComposite, SWT.BORDER);
		fkNameText.setLayoutData(gridData4);
		fkNameLabel = new Label(headDetailComposite, SWT.NONE);
		fkNameLabel.setText(Messages.getString("ForeignKeysComposite.ForeignKeysComposite.RefTable")); //$NON-NLS-1$
		createRefTableCombo();
	}

	/**
	 * This method initializes refTableCombo	
	 *
	 */
	private void createRefTableCombo() {
		GridData gridData5 = new GridData();
		gridData5.widthHint = 120;
		refTableCombo = new Combo(headDetailComposite, SWT.READ_ONLY);
		refTableCombo.setLayoutData(gridData5);
		refTableComboViewer = new ComboViewer(refTableCombo);
	}

	/**
	 * This method initializes footComposite	
	 *
	 */
	private void createFootComposite() {
		GridLayout gridLayout4 = new GridLayout();
		gridLayout4.numColumns = 2;
		footComposite = new Composite(detailFKGroup, SWT.NONE);
		footComposite.setLayout(gridLayout4);
		addDetailButton = new Button(footComposite, SWT.NONE);
		addDetailButton.setText(Messages.getString("ForeignKeysComposite.ForeignKeysComposite.Add")); //$NON-NLS-1$
		deleteDetailButton = new Button(footComposite, SWT.NONE);
		deleteDetailButton.setText(Messages.getString("ForeignKeysComposite.ForeignKeysComposite.Delete")); //$NON-NLS-1$
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
