/*******************************************************************************
 * Copyright (c) 2006 NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     NEC Soft, Ltd.- initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.tablewizard.ui.wizardpages.pk;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.datatools.sqltools.tablewizard.ui.utils.ResourceLoader;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.layout.GridData;

/**
 * 
 * @author yuanying
 *
 */
public class GenericPrimaryKeyComposite extends Composite {
	
	private static final String PRIMARY_KEY_LABEL = "primary_key.label"; //$NON-NLS-1$
	private static final String PRIMARY_KEY_MEMBERS_LABEL = "primary_key.members.label"; //$NON-NLS-1$

	private Label primaryKeyLabel = null;

	private List primaryKeyMemberList = null;

	private ListViewer primaryKeyMemberListViewer = null;

	private Text primaryKeynNameText = null;

	private Label membersLabel = null;
	
	public GenericPrimaryKeyComposite(Composite parent, int style) {
		super(parent, style);
		initialize();
	}

	/**
	 * 
	 * @return the primaryKeynNameText
	 */
	public Text getPrimaryKeynNameText() {
		return primaryKeynNameText;
	}

	/**
	 * @return the primaryKeyListViewer
	 */
	public ListViewer getPrimaryKeyMemberListViewer() {
		return primaryKeyMemberListViewer;
	}

	private void initialize() {
		GridData gridData3 = new GridData();
		gridData3.horizontalAlignment = GridData.BEGINNING;
		gridData3.verticalAlignment = GridData.BEGINNING;
		GridData gridData2 = new GridData();
		gridData2.horizontalAlignment = GridData.BEGINNING;
		gridData2.verticalAlignment = GridData.BEGINNING;
		GridData gridData1 = new GridData();
		gridData1.widthHint = 120;
		gridData1.verticalAlignment = GridData.BEGINNING;
		gridData1.horizontalAlignment = GridData.BEGINNING;
		GridData gridData = new GridData();
		gridData.grabExcessHorizontalSpace = true;
		gridData.verticalAlignment = GridData.BEGINNING;
		gridData.widthHint = 120;
		gridData.heightHint = 200;
		gridData.horizontalAlignment = GridData.FILL;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		primaryKeyLabel = new Label(this, SWT.NONE);
		primaryKeyLabel.setText(ResourceLoader.queryString(PRIMARY_KEY_LABEL));
		primaryKeyLabel.setLayoutData(gridData2);
		primaryKeynNameText = new Text(this, SWT.BORDER);
		primaryKeynNameText.setLayoutData(gridData1);
		membersLabel = new Label(this, SWT.NONE);
		membersLabel.setText(ResourceLoader.queryString(PRIMARY_KEY_MEMBERS_LABEL));
		membersLabel.setLayoutData(gridData3);
		primaryKeyMemberList = new List(this, SWT.MULTI | SWT.V_SCROLL);
		primaryKeyMemberList.setLayoutData(gridData);
		primaryKeyMemberListViewer = new ListViewer(primaryKeyMemberList);
		this.setLayout(gridLayout);
		this.setSize(new Point(530, 368));
	}

}
