/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.commands;

import javax.wsdl.OperationType;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.IASDAddCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddBaseParameterCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddFaultCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddInputCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddInputParameterCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddMessageReferenceCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddOperationCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddOutputCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddOutputParameterCommand;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;

public class W11AddOperationCommand
extends W11TopLevelElementCommand
implements IASDAddCommand {
    private PortType portType;
    private Operation operation;

    public W11AddOperationCommand(PortType portType) {
        super(Messages._UI_ACTION_ADD_OPERATION, portType.getEnclosingDefinition());
        this.portType = portType;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            this.beginRecording(this.portType.getElement());
            String name = NameUtil.getOperationName(this.portType);
            AddOperationCommand operationCommand = new AddOperationCommand(this.portType, name);
            operationCommand.run();
            this.operation = (Operation)operationCommand.getWSDLElement();
            this.createMessage(this.operation, 1);
            this.createMessage(this.operation, 2);
            this.createParameter(this.operation, null, 1);
            this.createParameter(this.operation, null, 2);
            this.operation.setStyle(OperationType.REQUEST_RESPONSE);
            this.formatChild(this.operation.getElement());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.endRecording(this.portType.getElement());
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.endRecording(this.portType.getElement());
    }

    public Object getNewlyAddedComponent() {
        return this.operation;
    }

    private MessageReference createMessage(Operation operation, int messageKind) {
        MessageReference messageRef = null;
        AddMessageReferenceCommand messageRefCommand = null;
        if (messageKind == 1) {
            messageRefCommand = new AddInputCommand(operation, null);
        } else if (messageKind == 2) {
            messageRefCommand = new AddOutputCommand(operation, null);
        } else if (messageKind == 3) {
            messageRefCommand = new AddFaultCommand(operation, NameUtil.getFaultName(operation));
        }
        messageRefCommand.run();
        messageRef = (MessageReference)messageRefCommand.getWSDLElement();
        return messageRef;
    }

    private void createParameter(Operation operation, Part part, int kind) {
        Object parameter = null;
        AddBaseParameterCommand addParameterCommand = null;
        if (kind == 1) {
            int parameterPattern = AddBaseParameterCommand.getParameterPattern((WSDLElement)this.portType, true);
            if (parameterPattern == -1) {
                parameterPattern = AddBaseParameterCommand.PART_ELEMENT_SEQ_ELEMENT;
            }
            addParameterCommand = new AddInputParameterCommand(operation, parameterPattern);
        } else if (kind == 2) {
            int parameterPattern = AddBaseParameterCommand.getParameterPattern((WSDLElement)this.portType, false);
            if (parameterPattern == -1) {
                parameterPattern = AddBaseParameterCommand.PART_ELEMENT_SEQ_ELEMENT;
            }
            addParameterCommand = new AddOutputParameterCommand(operation, parameterPattern);
        }
        if (parameter == null && addParameterCommand != null) {
            addParameterCommand.run();
        }
    }
}

