/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.ui.command;

import java.net.URI;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.ui.plugin.WSUIPlugin;
import org.eclipse.wst.ws.internal.wsrt.IContext;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

public class OpenEditorCommand
extends AbstractDataModelOperation {
    private static final String PLATFORM_RESOURCE = "platform:/resource/";
    private IWebService webService;
    private IContext context;

    public void setWebService(IWebService webService) {
        this.webService = webService;
    }

    public void setContext(IContext context) {
        this.context = context;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.context.getScenario().getValue() != 1) {
            return Status.OK_STATUS;
        }
        String[] implURLs = this.webService.getWebServiceInfo().getImplURLs();
        if (implURLs == null) {
            return Status.OK_STATUS;
        }
        IFile file = null;
        int i = 0;
        while (i < implURLs.length) {
            try {
                IWorkbenchPage page;
                URI uri = new URI(implURLs[i]);
                IPath path = URIUtil.toPath((URI)uri);
                if (path != null) {
                    file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
                } else if (implURLs[i].startsWith(PLATFORM_RESOURCE)) {
                    path = new Path(uri.getPath()).removeFirstSegments(1);
                    file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                }
                if (file != null && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
            }
            catch (Exception e) {
                WSUIPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.wst.ws.ui", 0, e.getMessage(), (Throwable)e));
            }
            ++i;
        }
        return Status.OK_STATUS;
    }
}

