/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentDescriptionProvider;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.adt.edit.IComponentDialog;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddXSDElementCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateElementReferenceAndManageDirectivesCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateElementReferenceCommand;
import org.eclipse.wst.xsd.ui.internal.dialogs.NewElementDialog;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.search.XSDSearchListDialogDelegate;
import org.eclipse.wst.xsd.ui.internal.search.IXSDSearchConstants;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;

public class XSDElementReferenceEditManager
implements ComponentReferenceEditManager {
    protected IFile currentFile;
    protected XSDSchema[] schemas;

    public XSDElementReferenceEditManager(IFile currentFile, XSDSchema[] schemas) {
        this.currentFile = currentFile;
        this.schemas = schemas;
    }

    public void addToHistory(ComponentSpecification component) {
    }

    public IComponentDialog getBrowseDialog() {
        XSDSearchListDialogDelegate dialogDelegate = new XSDSearchListDialogDelegate(XSDSearchListDialogDelegate.ELEMENT_META_NAME, this.currentFile, this.schemas);
        return dialogDelegate;
    }

    public IComponentDescriptionProvider getComponentDescriptionProvider() {
        return null;
    }

    public ComponentSpecification[] getHistory() {
        ArrayList list = new ArrayList();
        ComponentSpecification[] result = new ComponentSpecification[list.size()];
        list.toArray(result);
        return result;
    }

    public IComponentDialog getNewDialog() {
        if (this.schemas.length > 0) {
            return new NewElementDialog(this.schemas[0]);
        }
        return new NewElementDialog();
    }

    public ComponentSpecification[] getQuickPicks() {
        ArrayList list = new ArrayList();
        ComponentSpecification[] result = new ComponentSpecification[list.size()];
        list.toArray(result);
        return result;
    }

    public void modifyComponentReference(Object referencingObject, ComponentSpecification component) {
        Adapter adapter;
        if (referencingObject instanceof Adapter && (adapter = (Adapter)referencingObject).getTarget() instanceof XSDConcreteComponent) {
            XSDElementDeclaration concreteComponent = (XSDElementDeclaration)adapter.getTarget();
            if (component.isNew()) {
                BaseCommand command;
                XSDElementDeclaration elementDec = null;
                if (component.getMetaName() == IXSDSearchConstants.ELEMENT_META_NAME) {
                    command = new AddXSDElementCommand(Messages._UI_ACTION_ADD_ELEMENT, concreteComponent.getSchema());
                    ((AddXSDElementCommand)command).setNameToAdd(component.getName());
                    ((AddXSDElementCommand)command).execute();
                    elementDec = (XSDElementDeclaration)((AddXSDElementCommand)command).getAddedComponent();
                }
                if (elementDec != null) {
                    command = new UpdateElementReferenceCommand(Messages._UI_ACTION_UPDATE_ELEMENT_REFERENCE, concreteComponent, elementDec);
                    command.execute();
                }
            } else {
                UpdateElementReferenceAndManageDirectivesCommand command = new UpdateElementReferenceAndManageDirectivesCommand((XSDConcreteComponent)concreteComponent, component.getName(), component.getQualifier(), component.getFile());
                command.setLabel(Messages._UI_ACTION_UPDATE_ELEMENT_REFERENCE);
                command.execute();
            }
        }
    }
}

