/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.internal.emfworkbench.DynamicGrowthModel;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;

public class EditModelLeastUsedCache {
    private final DynamicGrowthModel dynamicGrowthModel = new DynamicGrowthModel();
    static EditModelLeastUsedCache INSTANCE = new EditModelLeastUsedCache();
    private int threshhold = this.dynamicGrowthModel.getOptimalSize();
    private LinkedHashSet lru = new LinkedHashSet(this.threshhold);

    void removeAllCached(Collection aCollection) {
        if (aCollection != null) {
            this.lru.removeAll(aCollection);
        }
    }

    void access(EditModel editModel) {
        if (this.lru.contains(editModel)) {
            this.moveToEnd(editModel);
        } else {
            editModel.access(this);
            this.lru.add(editModel);
        }
        IPath key = editModel.getProject().getFullPath().append(editModel.getEditModelID());
        if (this.dynamicGrowthModel.injectKey(key)) {
            this.optimizeLRUSize();
        }
    }

    private void optimizeLRUSize() {
        if (this.threshhold > this.dynamicGrowthModel.getOptimalSize() && this.lru.size() >= this.threshhold) {
            int iterations = this.lru.size() - this.threshhold + 1;
            int i = 0;
            Iterator iterator = this.lru.iterator();
            if (iterator.hasNext() && i < iterations) {
                EditModel model = (EditModel)iterator.next();
                if (model != null) {
                    this.lru.remove(model);
                    model.releaseAccess(this);
                }
                ++i;
            }
        }
        this.threshhold = this.dynamicGrowthModel.getOptimalSize();
    }

    private void moveToEnd(EditModel editModel) {
        this.lru.remove(editModel);
        this.lru.add(editModel);
    }
}

