/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.SaveFilter;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.datamodel.properties.IJ2EEComponentImportDataModelProperties;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public abstract class J2EEArtifactImportDataModelProvider
extends AbstractDataModelProvider
implements IJ2EEComponentImportDataModelProperties,
IDataModelListener {
    private static final String USE_DEFAULT_PROJECT_NAME = "J2EEArtifactImportDataModelProvider.USE_DEFAULT_PROJECT_NAME";
    public static final String FACET_RUNTIME = "IJ2EEArtifactImportDataModelProperties.FACET_RUNTIME";
    private IDataModel componentCreationDM;
    private OpenFailureException cachedOpenFailureException = null;
    private boolean settingFileName = false;
    private boolean doingComponentUpdate;

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IJ2EEArtifactImportDataModelProperties.FILE_NAME");
        propertyNames.add("IJ2EEArtifactImportDataModelProperties.FILE");
        propertyNames.add("IJ2EEArtifactImportDataModelProperties.SAVE_FILTER");
        propertyNames.add("IJ2EEArtifactImportDataModelProperties.OVERWRITE_HANDLER");
        propertyNames.add("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose");
        propertyNames.add(USE_DEFAULT_PROJECT_NAME);
        propertyNames.add("IJ2EEComponentImportDataModelProperties.PROJECT_NAME");
        propertyNames.add("IJ2EEComponentImportDataModelProperties.COMPONENT");
        propertyNames.add(FACET_RUNTIME);
        return propertyNames;
    }

    public void init() {
        super.init();
        this.componentCreationDM = this.createJ2EEComponentCreationDataModel();
        this.componentCreationDM.setBooleanProperty("FacetProjectCreationDataModelProvider.FORCE_VERSION_COMPLIANCE", false);
        this.componentCreationDM.addListener((IDataModelListener)this);
        this.model.addNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION", this.componentCreationDM);
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals(USE_DEFAULT_PROJECT_NAME)) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("IJ2EEComponentImportDataModelProperties.COMPONENT")) {
            String projectName = this.getStringProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME");
            IProject project = ProjectUtilities.getProject((String)projectName);
            return ComponentCore.createComponent((IProject)project);
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IJ2EEArtifactImportDataModelProperties.FILE")) {
            if (!this.settingFileName) {
                this.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", null);
            }
            this.updateDefaultComponentName();
            return true;
        }
        if (propertyName.equals("IJ2EEArtifactImportDataModelProperties.SAVE_FILTER") && this.getArchiveFile() != null) {
            this.getArchiveFile().setSaveFilter(this.getSaveFilter());
        } else if ("IJ2EEArtifactImportDataModelProperties.FILE_NAME".equals(propertyName)) {
            try {
                this.cachedOpenFailureException = null;
                this.handleArchiveSetup((String)propertyValue);
            }
            catch (OpenFailureException oe) {
                this.cachedOpenFailureException = oe;
            }
        } else {
            if ("IJ2EEComponentImportDataModelProperties.COMPONENT".equals(propertyName)) {
                throw new RuntimeException(String.valueOf(propertyName) + " should not be set.");
            }
            if ("IJ2EEComponentImportDataModelProperties.PROJECT_NAME".equals(propertyName)) {
                ArrayList nestedModels = new ArrayList(this.model.getNestedModels());
                IDataModel nestedModel = null;
                int i = 0;
                while (i < nestedModels.size()) {
                    nestedModel = (IDataModel)nestedModels.get(i);
                    try {
                        nestedModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", propertyValue);
                    }
                    catch (Exception e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                    ++i;
                }
            } else if (FACET_RUNTIME.equals(propertyName)) {
                throw new RuntimeException(String.valueOf(propertyName) + " should not be set.");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateDefaultComponentName() {
        Archive archive = this.getArchiveFile();
        if (archive == null) return;
        if (!this.getBooleanProperty(USE_DEFAULT_PROJECT_NAME)) return;
        try {
            this.doingComponentUpdate = true;
            Path path = new Path(archive.getURI());
            String defaultProjectName = path.segment(path.segmentCount() - 1);
            if (defaultProjectName.indexOf(46) > 0) {
                defaultProjectName = defaultProjectName.substring(0, defaultProjectName.lastIndexOf(46));
            }
            this.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", defaultProjectName);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.doingComponentUpdate = false;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.doingComponentUpdate = false;
            return;
        }
    }

    private boolean handleArchiveSetup(String fileName) throws OpenFailureException {
        String uri;
        Archive archive;
        block5: {
            try {
                this.settingFileName = true;
                archive = this.getArchiveFile();
                if (archive != null) {
                    archive.close();
                    this.setProperty("IJ2EEArtifactImportDataModelProperties.FILE", null);
                }
                uri = this.getStringProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME");
                if (this.archiveExistsOnFile()) break block5;
                Object var4_4 = null;
                this.settingFileName = false;
                return false;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.settingFileName = false;
                throw throwable;
            }
        }
        archive = this.openArchive(uri);
        if (archive != null) {
            archive.setSaveFilter(this.getSaveFilter());
        }
        this.setProperty("IJ2EEArtifactImportDataModelProperties.FILE", archive);
        boolean bl = archive != null;
        Object var4_5 = null;
        this.settingFileName = false;
        return bl;
    }

    protected abstract Archive openArchive(String var1) throws OpenFailureException;

    private boolean closeModuleFile() {
        if (this.getArchiveFile() != null) {
            this.getArchiveFile().close();
        }
        return true;
    }

    public IStatus validate(String propertyName) {
        if ("IJ2EEArtifactImportDataModelProperties.FILE_NAME".equals(propertyName) && !this.isPropertySet("IJ2EEArtifactImportDataModelProperties.FILE")) {
            String fileName = this.getStringProperty(propertyName);
            if (fileName == null || fileName.length() == 0) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"5", (Object[])new Object[]{ArchiveUtil.getModuleFileTypeName((int)this.getType())}));
            }
            if (this.cachedOpenFailureException != null) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)this.cachedOpenFailureException.getMessage()));
            }
            if (fileName != null && !this.archiveExistsOnFile()) {
                return WTPCommonPlugin.createErrorStatus((String)WTPCommonPlugin.getResourceString((String)"6", (Object[])new Object[]{ArchiveUtil.getModuleFileTypeName((int)this.getType())}));
            }
        } else {
            if ("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION".equals(propertyName)) {
                return this.getDataModel().getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION").validate(true);
            }
            if (FACET_RUNTIME.equals(propertyName)) {
                return this.validateVersionSupportedByServer();
            }
        }
        return OK_STATUS;
    }

    protected int getJ2EEVersion() {
        return 0;
    }

    protected abstract IDataModel createJ2EEComponentCreationDataModel();

    protected abstract int getType();

    private boolean archiveExistsOnFile() {
        String jarName = (String)this.getProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME");
        if (jarName != null && jarName.length() > 0) {
            File file = new File(jarName);
            return file.exists() && !file.isDirectory();
        }
        return false;
    }

    public void dispose() {
        if (this.getBooleanProperty("IJ2EEArtifactImportDataModelProperties.closeArchiveOnDispose")) {
            this.closeModuleFile();
        }
        super.dispose();
    }

    protected final void setArchiveFile(Archive archiveFile) {
        this.setProperty("IJ2EEArtifactImportDataModelProperties.FILE", archiveFile);
    }

    protected final Archive getArchiveFile() {
        return (Archive)this.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
    }

    protected final ArchiveOptions getArchiveOptions() {
        ArchiveOptions opts = new ArchiveOptions();
        opts.setIsReadOnly(true);
        return opts;
    }

    private SaveFilter getSaveFilter() {
        return (SaveFilter)this.getProperty("IJ2EEArtifactImportDataModelProperties.SAVE_FILTER");
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        return super.getValidPropertyDescriptors(propertyName);
    }

    public void propertyChanged(DataModelEvent event) {
        if (!this.doingComponentUpdate && event.getDataModel() == this.componentCreationDM && event.getPropertyName().equals("IJ2EEComponentImportDataModelProperties.PROJECT_NAME") && this.getBooleanProperty(USE_DEFAULT_PROJECT_NAME)) {
            this.setBooleanProperty(USE_DEFAULT_PROJECT_NAME, false);
        }
        if (event.getDataModel() == this.componentCreationDM && event.getPropertyName().equals("IFacetProjectCreationDataModelProperties.FACET_RUNTIME")) {
            this.model.notifyPropertyChange(FACET_RUNTIME, 2);
        }
    }

    protected IStatus validateVersionSupportedByServer() {
        if (this.model.isPropertySet("IJ2EEArtifactImportDataModelProperties.FILE")) {
            IDataModel projectModel = this.model.getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION");
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)projectModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            Collection projectFacets = (Collection)this.getProperty("FacetProjectCreationDataModelProvider.REQUIRED_FACETS_COLLECTION");
            IRuntime runtime = (IRuntime)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
            Iterator iterator = projectFacets.iterator();
            while (iterator.hasNext()) {
                IDataModel facetDataModel = map.getFacetDataModel(((IProjectFacet)iterator.next()).getId());
                IProjectFacetVersion facetVersion = (IProjectFacetVersion)facetDataModel.getProperty("IFacetDataModelPropeties.FACET_VERSION");
                if (facetVersion.getProjectFacet().getId().equals("jst.java")) {
                    Set<IProjectFacet> set = Collections.singleton(facetVersion.getProjectFacet());
                    try {
                        if (runtime != null) {
                            Set correctSet = runtime.getDefaultFacets(set);
                            IProjectFacetVersion correctVersion = null;
                            Iterator correctVersions = correctSet.iterator();
                            while (correctVersions.hasNext() && correctVersion == null) {
                                IProjectFacetVersion version = (IProjectFacetVersion)correctVersions.next();
                                if (!version.getProjectFacet().getId().equals("jst.java")) continue;
                                correctVersion = version;
                            }
                            if (correctVersion != null) {
                                facetDataModel.setProperty("IFacetDataModelPropeties.FACET_VERSION", correctVersion);
                                facetVersion = correctVersion;
                            }
                        }
                    }
                    catch (CoreException e) {
                        Logger.getLogger().logError((Throwable)e);
                    }
                }
                if (runtime == null || runtime.supports(facetVersion)) continue;
                return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.VERSION_NOT_SUPPORTED);
            }
        }
        return OK_STATUS;
    }
}

