/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.EARArchiveOpsResourceHandler;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public abstract class ComponentLoadStrategyImpl
extends LoadStrategyImpl {
    protected static final String DOT_PROJECT = ".project";
    protected static final String DOT_CLASSPATH = ".classpath";
    protected static final String DOT_SETTINGS = ".settings";
    protected static final String DOT_CVS_IGORE = ".cvsignore";
    protected IVirtualComponent vComponent;
    protected boolean exportSource;
    private ArtifactEdit artifactEdit;
    private List zipFiles = new ArrayList();
    protected FilesHolder filesHolder;
    private Exception exception;
    static /* synthetic */ Class class$0;

    public ComponentLoadStrategyImpl(IVirtualComponent vComponent) {
        this.vComponent = vComponent;
        this.filesHolder = new FilesHolder();
        this.exception = new Exception();
    }

    public boolean contains(String uri) {
        IVirtualFolder rootFolder = this.vComponent.getRootFolder();
        return rootFolder.getFile((IPath)new Path(uri)).exists();
    }

    protected void initializeResourceSet() {
        this.resourceSet = WorkbenchResourceHelperBase.getResourceSet((IProject)this.vComponent.getProject());
    }

    protected boolean primContains(String uri) {
        return false;
    }

    public List getFiles() {
        this.aggregateSourceFiles();
        this.aggregateClassFiles();
        this.addUtilities();
        return this.filesHolder.getFiles();
    }

    protected void addUtilities() {
        IVirtualReference[] components = this.vComponent.getReferences();
        int i = 0;
        while (i < components.length) {
            IVirtualReference reference = components[i];
            IVirtualComponent referencedComponent = reference.getReferencedComponent();
            if (referencedComponent.isBinary() && reference.getDependencyType() == 1) {
                File diskFile = ((VirtualArchiveComponent)referencedComponent).getUnderlyingDiskFile();
                IPath path = reference.getRuntimePath();
                try {
                    ZipFile zipFile = new ZipFile(diskFile);
                    this.zipFiles.add(zipFile);
                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry entry = enumeration.nextElement();
                        this.filesHolder.addEntry(entry, zipFile, path);
                    }
                }
                catch (ZipException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
                catch (IOException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
            ++i;
        }
    }

    protected void aggregateSourceFiles() {
        try {
            IVirtualFolder rootFolder = this.vComponent.getRootFolder();
            IVirtualResource[] members = rootFolder.members();
            this.aggregateFiles(members);
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    protected void aggregateClassFiles() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 395->399)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean aggregateOutputFiles(IResource[] resources, IPath runtimePathPrefix, int outputFolderSegmentCount) throws CoreException {
        boolean fileAdded = false;
        int i = 0;
        while (i < resources.length) {
            org.eclipse.jst.j2ee.commonarchivecore.internal.File cFile = null;
            if (resources[i].exists()) {
                String uri;
                IPath runtimePath = runtimePathPrefix.append(resources[i].getProjectRelativePath().removeFirstSegments(outputFolderSegmentCount));
                String string = uri = runtimePath == null ? null : runtimePath.toString();
                if (uri != null) {
                    if (resources[i].getType() == 1) {
                        if (this.shouldInclude(uri)) {
                            cFile = this.createFile(uri);
                            cFile.setLastModified(this.getLastModified(resources[i]));
                            this.filesHolder.addFile(cFile, resources[i]);
                            fileAdded = true;
                        }
                    } else if (this.shouldInclude((IContainer)resources[i])) {
                        IResource[] nestedResources = ((IContainer)resources[i]).members();
                        this.aggregateOutputFiles(nestedResources, runtimePathPrefix, outputFolderSegmentCount);
                        if (!this.filesHolder.contains(uri) && this.shouldInclude(uri)) {
                            cFile = this.createDirectory(uri);
                            cFile.setLastModified(this.getLastModified(resources[i]));
                            this.filesHolder.addDirectory(cFile);
                            fileAdded = true;
                        }
                    }
                }
            }
            ++i;
        }
        return fileAdded;
    }

    protected boolean aggregateFiles(IVirtualResource[] virtualResources) throws CoreException {
        boolean fileAdded = false;
        int i = 0;
        while (i < virtualResources.length) {
            org.eclipse.jst.j2ee.commonarchivecore.internal.File cFile = null;
            if (virtualResources[i].exists()) {
                String uri;
                IPath runtimePath = virtualResources[i].getRuntimePath();
                String string = uri = runtimePath == null ? null : runtimePath.toString();
                if (uri != null) {
                    if (uri.charAt(0) == '/') {
                        uri = uri.substring(1);
                    }
                    if (!this.filesHolder.contains(uri)) {
                        if (virtualResources[i].getType() == 16) {
                            IResource resource;
                            if (this.shouldInclude(uri) && !(resource = virtualResources[i].getUnderlyingResource()).isDerived()) {
                                cFile = this.createFile(uri);
                                cFile.setLastModified(this.getLastModified(resource));
                                this.filesHolder.addFile(cFile, resource);
                                fileAdded = true;
                            }
                        } else if (this.shouldInclude((IVirtualContainer)virtualResources[i])) {
                            IResource resource;
                            IVirtualResource[] nestedVirtualResources = ((IVirtualContainer)virtualResources[i]).members();
                            this.aggregateFiles(nestedVirtualResources);
                            if (!this.filesHolder.contains(uri) && this.shouldInclude(uri) && !(resource = virtualResources[i].getUnderlyingResource()).isDerived()) {
                                cFile = this.createDirectory(uri);
                                cFile.setLastModified(this.getLastModified(resource));
                                this.filesHolder.addDirectory(cFile);
                                fileAdded = true;
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return fileAdded;
    }

    protected long getLastModified(IResource aResource) {
        return aResource.getLocation().toFile().lastModified();
    }

    public void setExportSource(boolean newExportSource) {
        this.exportSource = newExportSource;
    }

    public boolean isExportSource() {
        return this.exportSource;
    }

    protected boolean shouldInclude(IContainer aContainer) {
        return true;
    }

    protected boolean shouldInclude(IVirtualContainer vContainer) {
        IContainer iContainer = (IContainer)vContainer.getUnderlyingResource();
        return this.shouldInclude(iContainer);
    }

    protected boolean shouldInclude(String uri) {
        if (DOT_PROJECT.equals(uri) || DOT_CLASSPATH.equals(uri) || uri.endsWith(DOT_CVS_IGORE) || uri.startsWith(DOT_SETTINGS)) {
            return false;
        }
        return this.isExportSource() || !this.isSource(uri);
    }

    protected boolean isSource(String uri) {
        if (uri == null) {
            return false;
        }
        return uri.endsWith(".java") || uri.endsWith(".sqlj");
    }

    protected void addExternalFile(String uri, File externalDiskFile) {
        org.eclipse.jst.j2ee.commonarchivecore.internal.File aFile = this.getArchiveFactory().createFile();
        aFile.setURI(uri);
        aFile.setOriginalURI(uri);
        aFile.setLoadingContainer(this.getContainer());
        this.filesHolder.addFile(aFile, externalDiskFile);
    }

    public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
        if (this.filesHolder.contains(uri)) {
            return this.filesHolder.getInputStream(uri);
        }
        IVirtualFolder rootFolder = this.vComponent.getRootFolder();
        IVirtualResource vResource = rootFolder.findMember(uri);
        String filePath = null;
        if (vResource != null && vResource.exists()) {
            filePath = vResource.getUnderlyingResource().getLocation().toOSString();
            File file = new File(filePath);
            return new FileInputStream(file);
        }
        String eString = EARArchiveOpsResourceHandler.ARCHIVE_OPERATION_FileNotFound;
        throw new FileNotFoundException(eString);
    }

    public Collection getLoadedMofResources() {
        Collection resources = super.getLoadedMofResources();
        ArrayList<Resource> resourcesToRemove = new ArrayList<Resource>();
        Iterator iterator = resources.iterator();
        while (iterator.hasNext()) {
            Resource res = (Resource)iterator.next();
            if (!res.getURI().toString().endsWith(".component")) continue;
            resourcesToRemove.add(res);
        }
        if (resourcesToRemove != null) {
            resources.removeAll(resourcesToRemove);
        }
        return resources;
    }

    protected synchronized ArtifactEdit getArtifactEditForRead() {
        if (this.artifactEdit == null) {
            this.artifactEdit = ArtifactEdit.getArtifactEditForRead((IVirtualComponent)this.vComponent);
        }
        return this.artifactEdit;
    }

    public Resource getMofResource(String uri) throws FileNotFoundException, ResourceLoadException {
        return this.getArtifactEditForRead().getResource(URI.createURI((String)uri));
    }

    public boolean isClassLoaderNeeded() {
        return false;
    }

    public IVirtualComponent getComponent() {
        return this.vComponent;
    }

    /*
     * Exception decompiling
     */
    public void close() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [7 : 224->227)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected class FilesHolder {
        private Map urisToFiles = new HashMap();
        private Map urisToResources = new HashMap();
        private Map resourcesToURI = new HashMap();
        private Map urisToDiskFiles;
        private Map urisToZipEntry = new HashMap();

        protected FilesHolder() {
        }

        public void removeIFile(IFile file) {
            String uri = (String)this.resourcesToURI.get(file);
            this.remove(uri);
        }

        public void remove(String uri) {
            this.urisToFiles.remove(uri);
            Object resource = this.urisToResources.remove(uri);
            if (resource != null) {
                this.resourcesToURI.remove(resource);
            }
            if (this.urisToDiskFiles != null) {
                this.urisToDiskFiles.remove(uri);
            }
        }

        public void addDirectory(org.eclipse.jst.j2ee.commonarchivecore.internal.File directory) {
            String uri = directory.getURI();
            this.urisToFiles.put(uri, directory);
        }

        public void addFile(org.eclipse.jst.j2ee.commonarchivecore.internal.File file) {
            String uri = file.getURI();
            this.urisToFiles.put(uri, file);
        }

        public void addFile(org.eclipse.jst.j2ee.commonarchivecore.internal.File file, File externalDiskFile) {
            String uri = file.getURI();
            this.urisToFiles.put(uri, file);
            if (this.urisToDiskFiles == null) {
                this.urisToDiskFiles = new HashMap();
            }
            this.urisToDiskFiles.put(uri, externalDiskFile);
        }

        public void addFile(org.eclipse.jst.j2ee.commonarchivecore.internal.File file, IResource resource) {
            String uri = file.getURI();
            this.urisToFiles.put(uri, file);
            this.urisToResources.put(uri, resource);
        }

        public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
            File diskFile = null;
            if (this.urisToDiskFiles != null && this.urisToDiskFiles.containsKey(uri)) {
                diskFile = (File)this.urisToDiskFiles.get(uri);
            } else if (this.urisToResources != null && this.urisToResources.containsKey(uri)) {
                IResource resource = (IResource)this.urisToResources.get(uri);
                diskFile = new File(resource.getLocation().toOSString());
            } else {
                Map fileURIMap = (Map)this.urisToZipEntry.get(uri);
                Iterator it = fileURIMap.keySet().iterator();
                String sourceFileUri = "";
                ZipFile zipFile = null;
                while (it.hasNext()) {
                    sourceFileUri = (String)it.next();
                    zipFile = (ZipFile)fileURIMap.get(sourceFileUri);
                }
                ZipEntry entry = zipFile.getEntry(sourceFileUri);
                InputStream in = zipFile.getInputStream(entry);
                return in;
            }
            return new FileInputStream(diskFile);
        }

        public List getFiles() {
            return new ArrayList(this.urisToFiles.values());
        }

        public boolean contains(String uri) {
            return this.urisToFiles.containsKey(uri);
        }

        public void addEntry(ZipEntry entry, ZipFile zipFile, IPath runtimePath) {
            String uri = runtimePath == null ? null : runtimePath.toString();
            String fileURI = "";
            fileURI = uri != null ? (!uri.equals("/") ? String.valueOf(uri) + entry.getName() : entry.getName()) : entry.getName();
            org.eclipse.jst.j2ee.commonarchivecore.internal.File file = ComponentLoadStrategyImpl.this.createFile(fileURI);
            HashMap<String, ZipFile> fileURIMap = new HashMap<String, ZipFile>();
            fileURIMap.put(entry.getName(), zipFile);
            this.urisToZipEntry.put(file.getURI(), fileURIMap);
            this.urisToFiles.put(file.getURI(), file);
        }
    }
}

