/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.navigator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.servlet.ui.internal.navigator.CompressedJavaLibraries;
import org.eclipse.jst.servlet.ui.internal.navigator.CompressedJavaProject;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class WebJavaContentProvider
implements IPipelinedTreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private static final String JAVA_EXTENSION_ID = "org.eclipse.jdt.java.ui.javaContent";
    private static Class INTERNAL_CONTAINER_CLASS;
    private CommonViewer commonViewer;
    private ITreeContentProvider delegateContentProvider;
    private final Map compressedNodes = new HashMap();

    static {
        try {
            INTERNAL_CONTAINER_CLASS = Class.forName("org.eclipse.jdt.internal.ui.packageview.ClassPathContainer");
        }
        catch (Throwable throwable) {
            INTERNAL_CONTAINER_CLASS = null;
        }
    }

    public void getPipelinedChildren(Object aParent, Set theCurrentChildren) {
        if (aParent instanceof IJavaProject) {
            this.cleanJavaContribution(theCurrentChildren);
            theCurrentChildren.add(this.getCompressedNode((IJavaProject)aParent));
        }
    }

    private void cleanJavaContribution(Set theCurrentChildren) {
        IJavaElement element = null;
        Iterator iter = theCurrentChildren.iterator();
        while (iter.hasNext()) {
            Object child = iter.next();
            if (child instanceof IResource && (element = JavaCore.create((IResource)((IResource)child))) != null && element.exists()) {
                iter.remove();
                continue;
            }
            if (child instanceof IJavaElement) {
                iter.remove();
                continue;
            }
            if (INTERNAL_CONTAINER_CLASS == null || !INTERNAL_CONTAINER_CLASS.isInstance(child)) continue;
            iter.remove();
        }
    }

    private CompressedJavaProject getCompressedNode(IJavaProject project) {
        CompressedJavaProject result = (CompressedJavaProject)this.compressedNodes.get(project);
        if (result == null) {
            result = new CompressedJavaProject((StructuredViewer)this.commonViewer, project);
            this.compressedNodes.put(project, result);
        }
        return result;
    }

    public void getPipelinedElements(Object anInput, Set theCurrentElements) {
    }

    public Object getPipelinedParent(Object anObject, Object aSuggestedParent) {
        if (anObject instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)anObject;
            if (!root.isExternal() && aSuggestedParent instanceof IJavaProject) {
                return this.getCompressedNode((IJavaProject)aSuggestedParent);
            }
        } else if (INTERNAL_CONTAINER_CLASS.isInstance(anObject) && aSuggestedParent instanceof IJavaProject) {
            return this.getCompressedNode((IJavaProject)aSuggestedParent).getCompressedJavaLibraries();
        }
        return null;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        IPackageFragmentRoot sourceFolder;
        CompressedJavaProject compressedNode;
        Object parent = anAddModification.getParent();
        if (parent instanceof IPackageFragmentRoot && (compressedNode = this.getCompressedNode((sourceFolder = (IPackageFragmentRoot)parent).getJavaProject())).isFlatteningSourceFolder()) {
            anAddModification.setParent((Object)compressedNode);
        }
        return anAddModification;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        IPackageFragmentRoot sourceFolder;
        CompressedJavaProject compressedNode;
        Object parent = aRemoveModification.getParent();
        if (parent instanceof IPackageFragmentRoot && (compressedNode = this.getCompressedNode((sourceFolder = (IPackageFragmentRoot)parent).getJavaProject())).isFlatteningSourceFolder()) {
            aRemoveModification.setParent((Object)compressedNode);
        }
        return aRemoveModification;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        Set refreshTargets = aRefreshSynchronization.getRefreshTargets();
        Iterator iter = refreshTargets.iterator();
        while (iter.hasNext()) {
            IPackageFragmentRoot sourceFolder;
            CompressedJavaProject compressedNode;
            Object refreshTarget = iter.next();
            if (!(refreshTarget instanceof IPackageFragmentRoot) || !(compressedNode = this.getCompressedNode((sourceFolder = (IPackageFragmentRoot)refreshTarget).getJavaProject())).isFlatteningSourceFolder()) continue;
            iter.remove();
            refreshTargets.add(compressedNode);
            return true;
        }
        return false;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        Set refreshTargets = anUpdateSynchronization.getRefreshTargets();
        Iterator iter = refreshTargets.iterator();
        while (iter.hasNext()) {
            CompressedJavaProject compressedNode;
            IPackageFragmentRoot sourceFolder;
            Object refreshTarget = iter.next();
            if (!(refreshTarget instanceof IPackageFragmentRoot) || (sourceFolder = (IPackageFragmentRoot)refreshTarget).getJavaProject() == null || !sourceFolder.getJavaProject().exists() || !sourceFolder.getJavaProject().isOpen() || !(compressedNode = this.getCompressedNode(sourceFolder.getJavaProject())).isFlatteningSourceFolder()) continue;
            iter.remove();
            refreshTargets.add(compressedNode);
            return true;
        }
        return false;
    }

    public void init(ICommonContentExtensionSite aSite) {
    }

    public Object[] getChildren(Object parentElement) {
        if (this.delegateContentProvider != null) {
            if (parentElement instanceof CompressedJavaProject) {
                return ((CompressedJavaProject)parentElement).getChildren(this.delegateContentProvider);
            }
            if (parentElement instanceof CompressedJavaLibraries) {
                return ((CompressedJavaLibraries)parentElement).getChildren(this.delegateContentProvider);
            }
        }
        return NO_CHILDREN;
    }

    public Object getParent(Object element) {
        if (element instanceof CompressedJavaProject) {
            return ((CompressedJavaProject)element).getProject();
        }
        if (element instanceof CompressedJavaLibraries) {
            return ((CompressedJavaLibraries)element).getCompressedProject();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof CompressedJavaProject || element instanceof CompressedJavaLibraries;
    }

    public Object[] getElements(Object inputElement) {
        return NO_CHILDREN;
    }

    public void dispose() {
        this.compressedNodes.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof CommonViewer) {
            this.commonViewer = (CommonViewer)viewer;
            INavigatorContentService service = this.commonViewer.getNavigatorContentService();
            INavigatorContentExtension javaext = service.getContentExtensionById(JAVA_EXTENSION_ID);
            if (javaext != null) {
                this.delegateContentProvider = javaext.getContentProvider();
            }
            this.compressedNodes.clear();
        }
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public boolean isClasspathContainer(Object o) {
        return INTERNAL_CONTAINER_CLASS != null && INTERNAL_CONTAINER_CLASS.isInstance(o);
    }
}

