/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.project.facet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public class ProductManager {
    private static final String APPLICATION_CONTENT_FOLDER = "EarContent";
    private static final String WEB_CONTENT_FOLDER = "WebContent";
    private static final String ADD_TO_EAR_BY_DEFAULT = "false";
    private static final String OUTPUT_FOLDER = "build/classes";
    private static final String FINAL_PERSPECTIVE = "org.eclipse.jst.j2ee.J2EEPerspective";
    private static final char RUNTIME_SEPARATOR = ':';
    private static final String[] DEFAULT_RUNTIME_KEYS = new String[]{"defaultRuntime1", "defaultRuntime2", "defaultRuntime3"};

    public static String getProperty(String key) {
        if (key == null) {
            return null;
        }
        String value = null;
        if (Platform.getProduct() != null) {
            value = Platform.getProduct().getProperty(key);
        }
        if (value == null) {
            if (key.equals("earContent")) {
                return APPLICATION_CONTENT_FOLDER;
            }
            if (key.equals("webContent")) {
                return WEB_CONTENT_FOLDER;
            }
            if (key.equals("addToEarByDefault")) {
                return ADD_TO_EAR_BY_DEFAULT;
            }
            if (key.equals("outputFolder")) {
                return OUTPUT_FOLDER;
            }
            if (key.equals("finalPerspectiveAppClient")) {
                return FINAL_PERSPECTIVE;
            }
            if (key.equals("finalPerspectiveEar")) {
                return FINAL_PERSPECTIVE;
            }
            if (key.equals("finalPerspectiveEjb")) {
                return FINAL_PERSPECTIVE;
            }
            if (key.equals("finalPerspectiveJca")) {
                return FINAL_PERSPECTIVE;
            }
            if (key.equals("finalPerspectiveStaticWeb")) {
                return null;
            }
            if (key.equals("finalPerspectiveUtility")) {
                return FINAL_PERSPECTIVE;
            }
            if (key.equals("finalPerspectiveWeb")) {
                return FINAL_PERSPECTIVE;
            }
        }
        return value;
    }

    public static boolean shouldAddToEARByDefault() {
        String value = ProductManager.getProperty("addToEarByDefault");
        return Boolean.valueOf(value);
    }

    public static List getDefaultRuntimes() {
        ArrayList<IRuntime> theRuntimes = null;
        Set runtimes = RuntimeManager.getRuntimes();
        if (!runtimes.isEmpty()) {
            IRuntime defaultRuntime = null;
            int i = 0;
            while (i < DEFAULT_RUNTIME_KEYS.length) {
                defaultRuntime = ProductManager.getMatchingRuntime(DEFAULT_RUNTIME_KEYS[i], runtimes);
                if (defaultRuntime != null) {
                    if (theRuntimes == null) {
                        theRuntimes = new ArrayList<IRuntime>(3);
                    }
                    theRuntimes.add(defaultRuntime);
                }
                ++i;
            }
        }
        if (theRuntimes == null) {
            theRuntimes = Collections.EMPTY_LIST;
        }
        return theRuntimes;
    }

    private static IRuntime getMatchingRuntime(String defaultProductRuntimeProperty, Set runtimes) {
        String defaultProductRuntimeKey = ProductManager.getProperty(defaultProductRuntimeProperty);
        if (defaultProductRuntimeKey == null || defaultProductRuntimeKey.length() == 0) {
            return null;
        }
        int seperatorIndex = defaultProductRuntimeKey.indexOf(58);
        if (seperatorIndex < 0 && seperatorIndex < defaultProductRuntimeKey.length()) {
            Logger.getLogger().logError("Invalid default product runtime id.  It should follow the format <facet runtime id>:<facet version>.  Id processed: " + defaultProductRuntimeKey);
            return null;
        }
        String defaultRuntimeID = defaultProductRuntimeKey.substring(0, seperatorIndex);
        String defaultFacetVersion = defaultProductRuntimeKey.substring(seperatorIndex + 1);
        Iterator runtimeIt = runtimes.iterator();
        while (runtimeIt.hasNext()) {
            IRuntime runtime = (IRuntime)runtimeIt.next();
            List runtimeComps = runtime.getRuntimeComponents();
            if (runtimeComps.isEmpty()) continue;
            Iterator compsIter = runtimeComps.iterator();
            while (compsIter.hasNext()) {
                IRuntimeComponent runtimeComp = (IRuntimeComponent)compsIter.next();
                if (!defaultRuntimeID.equals(runtimeComp.getRuntimeComponentType().getId()) || !defaultFacetVersion.equals(runtimeComp.getRuntimeComponentVersion().getVersionString())) continue;
                return runtime;
            }
        }
        return null;
    }
}

