/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.dnd;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.common.ui.internal.dnd.DefaultDragAndDropCommand;
import org.eclipse.wst.dtd.core.internal.CMBasicNode;
import org.eclipse.wst.dtd.core.internal.CMGroupNode;
import org.eclipse.wst.dtd.core.internal.CMNode;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Element;
import org.eclipse.wst.dtd.ui.internal.DTDUIMessages;

public class DragContentModelCommand
extends DefaultDragAndDropCommand {
    public DragContentModelCommand(Object target, float location, int operations, int operation, Collection sources) {
        super(target, location, operations, operation, sources);
    }

    public boolean canExecute() {
        if (!(this.target instanceof CMNode)) {
            return false;
        }
        Iterator iter = this.sources.iterator();
        while (iter.hasNext()) {
            Object source = iter.next();
            if (source instanceof CMNode) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        DTDNode referenceNode = (DTDNode)this.target;
        if (referenceNode instanceof CMNode) {
            DTDFile dtdFile = referenceNode.getDTDFile();
            DTDNode parent = (DTDNode)referenceNode.getParentNode();
            dtdFile.getDTDModel().beginRecording((Object)this, DTDUIMessages._UI_MOVE_CONTENT);
            boolean parentIsElement = false;
            Element element = null;
            CMGroupNode group = null;
            if (parent instanceof Element) {
                parentIsElement = true;
                element = (Element)parent;
            } else {
                group = (CMGroupNode)parent;
            }
            if (element == null && group == null) {
                return;
            }
            Iterator iter = this.sources.iterator();
            while (iter.hasNext()) {
                DTDNode node = (DTDNode)iter.next();
                if (!(node instanceof CMNode)) continue;
                if (parentIsElement) {
                    if (element.getContentModel() == node) continue;
                    element.replaceContentModel((Object)this, (CMNode)node);
                } else {
                    if (referenceNode == node || this.isAfter() && referenceNode.getNextSibling() == node || !this.isAfter() && node.getNextSibling() == referenceNode) continue;
                    group.insertIntoModel((Object)this, (CMNode)referenceNode, (CMNode)node, this.isAfter());
                }
                DTDNode nodeParent = (DTDNode)node.getParentNode();
                nodeParent.delete((Object)this, node);
            }
            dtdFile.getDTDModel().endRecording((Object)this);
        }
    }

    public int getFeedback() {
        CMNode cmNode;
        DTDNode referenceNode = (DTDNode)this.target;
        if (referenceNode instanceof CMNode && (cmNode = (CMNode)referenceNode).isRootElementContent() && cmNode instanceof CMBasicNode) {
            return 1;
        }
        return super.getFeedback();
    }
}

