/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.wizards;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.ConnectionSelectionWizard;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.shared.ExistingConnectionsWizardPage;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.shared.UserIdentification;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;

public class ConnectionSelectionExistingWizardPage
extends ExistingConnectionsWizardPage
implements SelectionListener {
    private static final ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
    protected boolean myFirstTime = true;
    protected Button reconnectButton;
    private boolean connected;

    public ConnectionSelectionExistingWizardPage(String aName) {
        super(aName);
    }

    public ConnectionSelectionExistingWizardPage(String aName, String aTitle, ImageDescriptor titleImage) {
        super(aName);
        this.setTitle(aTitle);
        this.setImageDescriptor(titleImage);
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        Composite control = (Composite)this.getControl();
        this.addReconnectButton(control);
    }

    private void addReconnectButton(Composite parent) {
        this.reconnectButton = new Button(parent, 8);
        this.reconnectButton.setText(resourceLoader.queryString("CUI_CONN_SELECT_EXT_RECONNECT_BTN_LBL"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 1;
        this.reconnectButton.setLayoutData((Object)data);
        this.reconnectButton.addSelectionListener((SelectionListener)this);
    }

    protected void setConnectionButton() {
        ConnectionInfo[] allInfos = this.getConnectionsToDisplay();
        int index = allInfos.length - 1;
        while (index >= 0) {
            if (allInfos[index].getDatabaseDefinition().getProduct().indexOf("DB2") > -1) {
                this.setDefaultConnection(allInfos[index].getName());
                break;
            }
            --index;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void widgetDefaultSelected(SelectionEvent evt) {
    }

    public void widgetSelected(SelectionEvent evt) {
        ConnectionInfo info;
        UserIdentification userDialog;
        Object source = evt.getSource();
        if (source == this.reconnectButton && (userDialog = new UserIdentification((info = this.getSelectedConnection()).getUserName(), null, info.getName())).open() == 0) {
            String us = userDialog.getUserNameInformation();
            String pa = userDialog.getPasswordInformation();
            info.setUserName(us);
            info.setPassword(pa);
            ConnectionSelectionWizard wizard = (ConnectionSelectionWizard)this.getWizard();
            try {
                wizard.reconnect(info);
                this.reconnectButton.setEnabled(false);
                this.connected = true;
                wizard.getContainer().updateButtons();
            }
            catch (Exception ex) {
                this.reconnectButton.setEnabled(true);
                this.connected = false;
                MessageDialog.openError((Shell)this.getShell(), (String)resourceLoader.queryString("CUI_CONN_SELECT_EXT_ERROR_DIALOG_TITLE"), (String)ex.getMessage());
            }
        }
    }

    public void handleEvent(Event event) {
        super.handleEvent(event);
        if (this.isNewConnectionSelected()) {
            this.reconnectButton.setEnabled(false);
        } else {
            ConnectionSelectionWizard wizard = (ConnectionSelectionWizard)this.getWizard();
            wizard.getContainer().updateButtons();
        }
    }

    public void refresh() {
        Database db = null;
        ConnectionInfo connInfo = this.getSelectedConnection();
        if (connInfo != null) {
            db = connInfo.getSharedDatabase();
        }
        if (db == null) {
            this.reconnectButton.setEnabled(true);
            this.connected = false;
        } else {
            this.reconnectButton.setEnabled(false);
            this.connected = true;
        }
    }

    public IWizardPage getNextPage() {
        IWizardPage page = null;
        ConnectionSelectionWizard conSelectWiz = (ConnectionSelectionWizard)this.getWizard();
        if (this.isExistingConnectionSelected()) {
            ConnectionInfo conInfo = this.getSelectedConnection();
            conSelectWiz.setConInfo(conInfo);
            this.refresh();
        } else {
            page = conSelectWiz.getPage("ConnectionSelectionJDBCWizardPage");
        }
        return page;
    }

    public void setVisible(boolean visible) {
        IWizardPage filterPage;
        super.setVisible(visible);
        if (visible && (filterPage = this.getWizard().getPage("ConnectionSelectionFilterWizardPage")) != null) {
            filterPage.getControl().setData("skip", (Object)Boolean.TRUE);
        }
        if (this.myFirstTime) {
            this.setConnectionButton();
            this.myFirstTime = false;
        }
    }
}

