/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.uri.URIException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.discovery.NetUtils;
import org.eclipse.wst.ws.internal.parser.wsil.WWWAuthenticationException;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.wsdl.internal.impl.XSDSchemaExtensibilityElementImpl;
import org.eclipse.wst.wsdl.internal.impl.wsdl4j.WSDLFactoryImpl;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CopyWSDLTreeCommand
extends AbstractDataModelOperation {
    private String wsdlURI;
    private WebServicesParser webServicesParser;
    private String destinationURI;
    private Definition def;
    private Vector ignoreList;
    private IPath pathPrefix;
    private String wsdlRelPath;
    private Vector xmlObjectInfos;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        CopyWSDLRunnable copyWSDLRunnable = new CopyWSDLRunnable(env);
        try {
            ResourceUtils.getWorkspace().run((IWorkspaceRunnable)copyWSDLRunnable, null);
            return Status.OK_STATUS;
        }
        catch (CoreException ce) {
            IStatus status = ce.getStatus();
            env.getStatusHandler().reportError(status);
            return status;
        }
    }

    private void updatePathPrefix(XMLObjectInfo info) {
        if (this.pathPrefix == null) {
            this.pathPrefix = info.path.removeLastSegments(1);
        } else {
            int matching = this.pathPrefix.matchingFirstSegments(info.path);
            if (matching < this.pathPrefix.segmentCount()) {
                this.pathPrefix = this.pathPrefix.uptoSegment(matching);
            }
        }
    }

    private void writeXMLObj(IEnvironment env, String destURI, String destLocalname, Definition definition) throws WSDLException, IOException, URIException {
        StringBuffer destinationFileURI = new StringBuffer(this.addTrailingSeparator(destURI));
        destinationFileURI.append(destLocalname);
        WSDLFactoryImpl wsdlFactory = new WSDLFactoryImpl();
        WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
        OutputStream os = env.getURIFactory().newURI(destinationFileURI.toString()).getOutputStream();
        wsdlWriter.writeWSDL(definition, os);
        os.close();
    }

    private void writeXMLObj(IEnvironment env, String destURI, String destLocalname, XSDSchema xsdSchema) throws TransformerConfigurationException, URIException, TransformerException, IOException {
        StringBuffer destinationFileURI = new StringBuffer(this.addTrailingSeparator(destURI));
        destinationFileURI.append(destLocalname);
        Element e = xsdSchema.getElement();
        DOMSource domSource = new DOMSource(e);
        Transformer serializer = TransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        OutputStream os = env.getURIFactory().newURI(destinationFileURI.toString()).getOutputStream();
        serializer.transform(domSource, new StreamResult(os));
        os.close();
    }

    private void copyWSDL(IEnvironment env, String uri, String destURI, String destLocalname) throws WSDLException, IOException, WWWAuthenticationException, TransformerException, TransformerConfigurationException, URIException {
        try {
            Definition definition = this.webServicesParser.getWSDLDefinitionVerbose(uri);
            this.copyWSDL(env, uri, destURI, destLocalname, definition);
        }
        catch (WSDLException wSDLException) {
            this.copyXMLSchema(env, uri, destURI);
        }
    }

    private void copyWSDL(IEnvironment env, String uri, String destURI, String destLocalname, Definition definition) throws WSDLException, IOException, WWWAuthenticationException, TransformerException, TransformerConfigurationException, URIException {
        if (!this.needToCopy(uri = this.normalize(uri))) {
            return;
        }
        destURI = this.normalize(destURI);
        String baseURI = this.getBaseURI(uri);
        if (destLocalname == null || destLocalname.length() <= 0) {
            destLocalname = this.getLocalname(uri);
        }
        XMLObjectInfo info = new XMLObjectInfo(String.valueOf(baseURI) + destLocalname, definition);
        this.updatePathPrefix(info);
        this.xmlObjectInfos.add(info);
        Map imports = definition.getImports();
        Iterator it = imports.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            Iterator listIt = list.iterator();
            while (listIt.hasNext()) {
                Import wsdlImport = (Import)listIt.next();
                String wsdlImportURI = wsdlImport.getLocationURI();
                if (!this.isRelative(wsdlImportURI)) continue;
                String importBaseURI = baseURI + wsdlImportURI;
                String wsdlImportBaseURI = this.getBaseURI(wsdlImportURI);
                StringBuffer importDestURI = new StringBuffer(destURI);
                if (wsdlImportBaseURI != null) {
                    importDestURI.append(wsdlImportBaseURI);
                }
                this.copyWSDL(env, importBaseURI, importDestURI.toString(), this.getLocalname(wsdlImportURI));
            }
        }
        Types types = definition.getTypes();
        if (types != null) {
            List schemas = types.getExtensibilityElements();
            Iterator it2 = schemas.iterator();
            while (it2.hasNext()) {
                XSDSchema xsdSchema;
                UnknownExtensibilityElement schemaElement;
                ExtensibilityElement extElement = (ExtensibilityElement)it2.next();
                if (extElement instanceof UnknownExtensibilityElement) {
                    schemaElement = (UnknownExtensibilityElement)extElement;
                    xsdSchema = null;
                    try {
                        xsdSchema = XSDSchemaImpl.createSchema((Node)schemaElement.getElement());
                    }
                    catch (Throwable throwable) {}
                    this.copyXMLSchema(env, xsdSchema, baseURI, destURI);
                    continue;
                }
                if (!(extElement instanceof XSDSchemaExtensibilityElementImpl)) continue;
                schemaElement = (XSDSchemaExtensibilityElementImpl)extElement;
                xsdSchema = null;
                try {
                    xsdSchema = XSDSchemaImpl.createSchema((Node)schemaElement.getElement());
                }
                catch (Throwable throwable) {}
                this.copyXMLSchema(env, xsdSchema, baseURI, destURI);
            }
        }
    }

    private String getBaseURI(String uri) {
        int index = uri.lastIndexOf(47);
        if (index == -1) {
            index = uri.lastIndexOf(92);
        }
        if (index != -1) {
            return uri.substring(0, index + 1);
        }
        return null;
    }

    private String getLocalname(String uri) {
        int index = uri.lastIndexOf(47);
        if (index == -1) {
            index = uri.lastIndexOf(92);
        }
        if (index != -1) {
            return uri.substring(index + 1);
        }
        return uri;
    }

    private String addTrailingSeparator(String s) {
        if (!s.endsWith("/") && !s.endsWith("\\")) {
            StringBuffer sb = new StringBuffer(s);
            sb.append('/');
            return sb.toString();
        }
        return s;
    }

    private boolean isRelative(String uri) {
        return uri.indexOf(58) == -1;
    }

    private void copyXMLSchema(IEnvironment env, String uri, String destURI) throws TransformerException, TransformerConfigurationException, IOException, URIException {
        if (!this.needToCopy(uri = this.normalize(uri))) {
            return;
        }
        destURI = this.normalize(destURI);
        XSDSchema xsdSchema = XSDSchemaImpl.getSchemaForSchema((String)uri);
        if (xsdSchema == null) {
            XSDParser p = new XSDParser();
            InputStream is = NetUtils.getURLInputStream((String)uri);
            if (is != null) {
                p.parse(is);
                xsdSchema = p.getSchema();
            }
        }
        if (xsdSchema != null) {
            XMLObjectInfo info = new XMLObjectInfo(uri, xsdSchema);
            this.updatePathPrefix(info);
            this.xmlObjectInfos.add(info);
            this.copyXMLSchema(env, xsdSchema, this.getBaseURI(uri), destURI);
        }
    }

    private void copyXMLSchema(IEnvironment env, XSDSchema xsdSchema, String baseURI, String destURI) throws TransformerException, TransformerConfigurationException, IOException, URIException {
        if (xsdSchema != null) {
            EList xsdSchemaContents = xsdSchema.getContents();
            Iterator it = xsdSchemaContents.iterator();
            while (it.hasNext()) {
                XSDSchemaDirective xsdSchemaDirective;
                String xsdSchemaDirectiveLocation;
                Object content = it.next();
                if (!(content instanceof XSDSchemaDirective) || (xsdSchemaDirectiveLocation = (xsdSchemaDirective = (XSDSchemaDirective)content).getSchemaLocation()) == null || !this.isRelative(xsdSchemaDirectiveLocation)) continue;
                String directiveURI = baseURI + xsdSchemaDirectiveLocation;
                String directiveBaseURI = this.getBaseURI(xsdSchemaDirectiveLocation);
                StringBuffer directiveDestURI = new StringBuffer(destURI);
                if (directiveBaseURI != null) {
                    directiveDestURI.append(directiveBaseURI);
                }
                this.copyXMLSchema(env, directiveURI, directiveDestURI.toString());
            }
        }
    }

    private boolean needToCopy(String normalizedURI) {
        if (this.ignoreList.contains(normalizedURI)) {
            return false;
        }
        this.ignoreList.add(normalizedURI);
        return true;
    }

    private String normalize(String uri) {
        boolean normalized = false;
        while (!normalized) {
            int dir = uri.indexOf("/..");
            if (dir == -1) {
                normalized = true;
                continue;
            }
            String first = uri.substring(0, dir);
            String second = uri.substring(dir + 3);
            int newIndex = first.lastIndexOf("/");
            if (newIndex == -1) {
                normalized = true;
                continue;
            }
            first = first.substring(0, newIndex);
            uri = String.valueOf(first) + second;
        }
        return uri;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public void setDestinationURI(String destinationURI) {
        this.destinationURI = destinationURI;
    }

    public void setDefinition(Definition def) {
        this.def = def;
    }

    public String getWSDLRelPath() {
        return this.wsdlRelPath;
    }

    private class CopyWSDLRunnable
    implements IWorkspaceRunnable {
        private IEnvironment environment = null;

        protected CopyWSDLRunnable(IEnvironment env) {
            this.environment = env;
        }

        public void run(IProgressMonitor pm) throws CoreException {
            CopyWSDLTreeCommand.this.ignoreList = new Vector();
            CopyWSDLTreeCommand.this.xmlObjectInfos = new Vector();
            if (CopyWSDLTreeCommand.this.def == null) {
                CopyWSDLTreeCommand.this.def = CopyWSDLTreeCommand.this.webServicesParser.getWSDLDefinition(CopyWSDLTreeCommand.this.wsdlURI);
            }
            try {
                String baseDestinationURI = CopyWSDLTreeCommand.this.getBaseURI(CopyWSDLTreeCommand.this.destinationURI);
                CopyWSDLTreeCommand.this.copyWSDL(this.environment, CopyWSDLTreeCommand.this.wsdlURI, baseDestinationURI, CopyWSDLTreeCommand.this.getLocalname(CopyWSDLTreeCommand.this.destinationURI), CopyWSDLTreeCommand.this.def);
                Iterator iter = CopyWSDLTreeCommand.this.xmlObjectInfos.iterator();
                while (iter.hasNext()) {
                    XMLObjectInfo info = (XMLObjectInfo)iter.next();
                    IPath relPath = info.path.removeFirstSegments(CopyWSDLTreeCommand.this.pathPrefix.segmentCount());
                    if (info.content instanceof Definition) {
                        Definition definition = (Definition)info.content;
                        if (definition == CopyWSDLTreeCommand.this.def) {
                            CopyWSDLTreeCommand.this.wsdlRelPath = relPath.toString();
                        }
                        CopyWSDLTreeCommand.this.writeXMLObj(this.environment, baseDestinationURI, relPath.toString(), definition);
                        continue;
                    }
                    CopyWSDLTreeCommand.this.writeXMLObj(this.environment, baseDestinationURI, relPath.toString(), (XSDSchema)info.content);
                }
            }
            catch (Throwable e) {
                throw new CoreException(StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_COPY_WSDL, (Object[])new String[]{CopyWSDLTreeCommand.this.wsdlURI, CopyWSDLTreeCommand.this.destinationURI}), (Throwable)e));
            }
        }
    }

    private class XMLObjectInfo {
        public IPath path;
        public Object content;

        public XMLObjectInfo(String uri, Object content) {
            int colon = uri.lastIndexOf(":");
            if (colon != -1) {
                uri = uri.substring(colon + 1, uri.length());
            }
            this.path = new Path(uri);
            this.content = content;
        }
    }
}

