/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.sqleditor.internal;

import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.sqleditor.internal.ISQLEditorInput;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorInputFactory;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorStorage;

public class SQLEditorStorageEditorInput
implements IStorageEditorInput,
ISQLEditorInput,
IPersistableElement {
    private ConnectionInfo fConnInfo;
    private Database fDatabase;
    private String fDefaultSchemaName;
    private String fName;
    private IStorage fStorage;

    public SQLEditorStorageEditorInput(String storageSource) {
        this(new SQLEditorStorage(storageSource));
    }

    public SQLEditorStorageEditorInput(IStorage storage) {
        if (storage == null) {
            throw new IllegalArgumentException();
        }
        this.setStorage(storage);
        this.setName(storage.getName());
        this.setConnectionInfo(null);
    }

    public boolean exists() {
        return this.fStorage != null;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.fConnInfo;
    }

    public Database getDatabase() {
        return this.fDatabase;
    }

    public String getDefaultSchemaName() {
        return this.fDefaultSchemaName;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fName;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public IStorage getStorage() {
        return this.fStorage;
    }

    public String getToolTipText() {
        StringBuffer sb = new StringBuffer(30);
        if (this.fConnInfo != null) {
            sb.append(this.fConnInfo.getName());
            sb.append("/");
        }
        sb.append(this.fName);
        return sb.toString();
    }

    public String getFactoryId() {
        return "org.eclipse.wst.rdb.sqleditor.SQLEditorInputFactory";
    }

    public void saveState(IMemento memento) {
        SQLEditorInputFactory.saveState(memento, this);
    }

    public void setConnectionInfo(ConnectionInfo connInfo) {
        this.fConnInfo = connInfo;
    }

    public void setDatabase(Database database) {
        this.fDatabase = database;
    }

    public void setDefaultSchemaName(String schemaName) {
        this.fDefaultSchemaName = schemaName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setStorage(IStorage storage) {
        this.fStorage = storage;
    }
}

