/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.fe.internal.ui.wizards;

import java.sql.SQLException;
import java.util.Vector;

import org.eclipse.wst.rdb.connection.internal.ui.wizards.shared.ExistingConnectionsWizardPage;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;

/**
 * @author ledunnel
 */
public class FESpecifyExistingConnectionsWizardPage extends
        ExistingConnectionsWizardPage {
    private String allowedProduct = null;

    private String allowedVersion = null;

    /**
     * @param pageName
     */
    public FESpecifyExistingConnectionsWizardPage(String pageName) {
        super(pageName);
    }

    protected ConnectionInfo[] getConnectionsToDisplay() {
        Vector filteredInfosCollection = new Vector();
        ConnectionInfo[] filteredInfos = new ConnectionInfo[] {};
        ConnectionInfo[] allInfos = RDBCorePlugin.getDefault()
                .getConnectionManager().getAllNamedConnectionInfo();
        if ((getAllowedProduct() != null) && (getAllowedVersion() != null)) {
            final int infoLength = allInfos.length;
            if (infoLength > 0) {
                for (int index = 0; index < infoLength; index++) {
                    if (allInfos[index].getDatabaseDefinition().getProduct()
                            .equals(getAllowedProduct())) {
                        filteredInfosCollection.add(allInfos[index]);
                    }
                    filteredInfos = new ConnectionInfo[filteredInfosCollection
                            .size()];
                    filteredInfosCollection.copyInto(filteredInfos);
                }
            }
        } else {
            filteredInfos = allInfos;
        }
        return filteredInfos;
    }

    /**
     * @param allowedProduct
     *            The allowedProduct to set.
     */
    public void setAllowedProduct(String allowedProduct) {
        this.allowedProduct = allowedProduct;
    }

    /**
     * @return Returns the allowedProduct.
     */
    public String getAllowedProduct() {
        return allowedProduct;
    }

    /**
     * @param allowedVersion
     *            The allowedVersion to set.
     */
    public void setAllowedVersion(String allowedVersion) {
        this.allowedVersion = allowedVersion;
    }

    /**
     * @return Returns the allowedVersion.
     */
    public String getAllowedVersion() {
        return allowedVersion;
    }

    public boolean isSelectedConnectionClosed() {
        boolean isClosed = true;
        ConnectionInfo connectionInfo = getSelectedConnection();
        if ((connectionInfo != null)
                && (connectionInfo.getSharedConnection() != null)) {
            try {
                if (!connectionInfo.getSharedConnection().isClosed()) {
                    isClosed = false;
                }
            } catch (SQLException e) {
            }
        }
        return isClosed;
    }
}