/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.properties.sections;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.actions.AddElementAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.model.AbstractModelCollection;
import org.eclipse.wst.wsdl.ui.internal.asd.properties.sections.ASDAbstractSection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DocumentationSection
extends ASDAbstractSection {
    org.eclipse.swt.widgets.Text docText;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.docText = this.getWidgetFactory().createText(this.composite, "", 770);
        this.docText.addListener(24, (Listener)this);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.docText.setLayoutData((Object)data);
    }

    public void refresh() {
        String docValue;
        Node textNode;
        Element docNode;
        super.refresh();
        if (this.docText.isFocusControl()) {
            return;
        }
        this.setListenerEnabled(false);
        this.docText.setText("");
        if (this.getModel() != null && this.getElement() != null && (docNode = this.getElement().getDocumentationElement()) != null && (textNode = docNode.getFirstChild()) != null && (docValue = textNode.getNodeValue()) != null) {
            this.docText.setText(docValue);
        }
        this.setListenerEnabled(true);
    }

    public void doHandleEvent(Event event) {
        if (event.widget == this.docText) {
            String value = this.docText.getText();
            if (this.getModel() != null && this.getElement() != null) {
                Element docNode = this.getElement().getDocumentationElement();
                if (docNode != null) {
                    Node textNode = docNode.getFirstChild();
                    if (textNode != null) {
                        textNode.setNodeValue(value);
                    } else if (value.length() > 0) {
                        Document document = docNode.getOwnerDocument();
                        Text newTextNode = document.createTextNode(value);
                        docNode.appendChild(newTextNode);
                    }
                } else {
                    Element element = this.getElement().getElement();
                    AddElementAction action = new AddElementAction(element, element.getPrefix(), "documentation", element.getFirstChild());
                    action.run();
                    Element newDocumentation = action.getNewElement();
                    Document document = newDocumentation.getOwnerDocument();
                    Text newTextNode = document.createTextNode(value);
                    newDocumentation.appendChild(newTextNode);
                    this.getElement().setDocumentationElement(newDocumentation);
                }
            }
        }
    }

    private WSDLElement getElement() {
        Notifier target;
        WSDLElement element = null;
        Object model = this.getModel();
        if (model instanceof AbstractModelCollection) {
            model = ((AbstractModelCollection)model).getModel();
        }
        if (model instanceof WSDLBaseAdapter && (target = ((WSDLBaseAdapter)model).getTarget()) instanceof WSDLElement) {
            element = (WSDLElement)target;
        }
        return element;
    }
}

