/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.editor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xsd.ui.internal.adt.editor.CommonSelectionManager;
import org.eclipse.wst.xsd.ui.internal.adt.editor.Messages;

public abstract class CommonMultiPageEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
CommandStackListener,
ITabbedPropertySheetPageContributor,
IPropertyListener {
    public static int SOURCE_PAGE_INDEX = 1;
    public static int DESIGN_PAGE_INDEX = 0;
    protected IContentOutlinePage fOutlinePage;
    protected DefaultEditDomain editDomain = new DefaultEditDomain((IEditorPart)this);
    protected SelectionSynchronizer synchronizer;
    protected ActionRegistry actionRegistry;
    protected StructuredTextEditor structuredTextEditor;
    protected CommonSelectionManager selectionProvider;
    protected ScrollingGraphicalViewer graphicalViewer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public abstract String getContributorId();

    protected abstract void createActions();

    protected void createPages() {
    }

    public void doSave(IProgressMonitor monitor) {
        this.structuredTextEditor.doSave(monitor);
        this.getCommandStack().markSaveLocation();
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(1);
        this.structuredTextEditor.doSaveAs();
        this.setInput(this.structuredTextEditor.getEditorInput());
        this.setPartName(editor.getTitle());
        this.getCommandStack().markSaveLocation();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = CommonMultiPageEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)CommonMultiPageEditor.this.structuredTextEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(CommonMultiPageEditor.this.structuredTextEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
    }

    public void propertyChanged(Object source, int propId) {
        switch (propId) {
            case 257: 
            case 258: {
                if (source != this.structuredTextEditor || this.structuredTextEditor.getEditorInput() == this.getEditorInput()) break;
                this.setInput(this.structuredTextEditor.getEditorInput());
                Runnable runnable = new Runnable(){

                    public void run() {
                        CommonMultiPageEditor.this._firePropertyChange(1);
                    }
                };
                this.postOnDisplayQue(runnable);
                break;
            }
            case 1: {
                if (source != this.structuredTextEditor || this.structuredTextEditor.getEditorInput() == this.getEditorInput()) break;
                this.setInput(this.structuredTextEditor.getEditorInput());
                break;
            }
            default: {
                if (source != this.structuredTextEditor) break;
                this.firePropertyChange(propId);
            }
        }
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SelectionSynchronizer();
        }
        return this.synchronizer;
    }

    public CommonSelectionManager getSelectionManager() {
        if (this.selectionProvider == null) {
            this.selectionProvider = new CommonSelectionManager(this);
        }
        return this.selectionProvider;
    }

    protected void _firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    protected void postOnDisplayQue(Runnable runnable) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows != null && windows.length > 0) {
            Display display = windows[0].getShell().getDisplay();
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public void dispose() {
        this.getCommandStack().removeCommandStackListener((CommandStackListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.actionRegistry.dispose();
        if (this.structuredTextEditor != null) {
            this.structuredTextEditor.removePropertyListener((IPropertyListener)this);
        }
        this.structuredTextEditor = null;
        this.editDomain = null;
        this.fOutlinePage = null;
        this.synchronizer = null;
        this.actionRegistry = null;
        this.selectionProvider = null;
        this.graphicalViewer = null;
        super.dispose();
    }

    protected CommandStack getCommandStack() {
        return this.editDomain.getCommandStack();
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        this.getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.initializeActionRegistry();
        String title = null;
        if (this.getEditorInput() != null) {
            title = this.getEditorInput().getName();
        }
        this.setPartName(title);
    }

    protected void initializeActionRegistry() {
        this.createActions();
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.commands.CommandStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return this.getCommandStack();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.gef.ui.actions.ActionRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz2) {
            return this.getActionRegistry();
        }
        return super.getAdapter(type);
    }

    protected DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    protected void updateActions(List actionIds) {
        ActionRegistry registry = this.getActionRegistry();
        Iterator iter = actionIds.iterator();
        while (iter.hasNext()) {
            IAction action = registry.getAction(iter.next());
            if (!(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    public boolean isDirty() {
        if (this.getCommandStack().isDirty()) {
            return true;
        }
        return super.isDirty();
    }

    public StructuredTextEditor getTextEditor() {
        return this.structuredTextEditor;
    }

    protected Composite createGraphPageComposite() {
        Composite parent = new Composite(this.getContainer(), 0);
        parent.setLayout((Layout)new FillLayout());
        return parent;
    }

    protected void createGraphPage() {
        Composite parent = this.createGraphPageComposite();
        this.graphicalViewer = this.getGraphicalViewer();
        this.graphicalViewer.createControl(parent);
        this.getEditDomain().addViewer((EditPartViewer)this.graphicalViewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        int index = this.addPage((Control)parent);
        this.setPageText(index, Messages._UI_LABEL_DESIGN);
    }

    protected void createSourcePage() {
        this.structuredTextEditor = new StructuredTextEditor();
        try {
            int index = this.addPage((IEditorPart)this.structuredTextEditor, this.getEditorInput());
            this.setPageText(index, Messages._UI_LABEL_SOURCE);
            this.structuredTextEditor.update();
            this.structuredTextEditor.setEditorPart((IEditorPart)this);
            this.structuredTextEditor.addPropertyListener((IPropertyListener)this);
            this.firePropertyChange(1);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    protected void configureGraphicalViewer() {
        ZoomManager manager;
        this.graphicalViewer.getControl().setBackground(ColorConstants.listBackground);
        org.eclipse.wst.xsd.ui.internal.adt.design.editparts.RootEditPart root = new org.eclipse.wst.xsd.ui.internal.adt.design.editparts.RootEditPart();
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        root.getZoomManager().setZoomLevelContributions(zoomLevels);
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomIn);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOut);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (ZoomManager)this.graphicalViewer.getProperty(clazz.toString())) != null) {
            manager.setZoom(1.0);
        }
        this.graphicalViewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)262144), (Object)MouseWheelZoomHandler.SINGLETON);
        this.graphicalViewer.setRootEditPart((RootEditPart)root);
        this.graphicalViewer.setEditPartFactory(this.getEditPartFactory());
    }

    protected void hookGraphicalViewer() {
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.graphicalViewer);
    }

    protected abstract ScrollingGraphicalViewer getGraphicalViewer();

    protected abstract EditPartFactory getEditPartFactory();

    protected abstract void initializeGraphicalViewer();
}

