/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.consumption.common.FacetMatcher;
import org.eclipse.jst.ws.internal.consumption.common.FacetSetsByTemplateCache;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public class CreateFacetedProjectCommand
extends AbstractDataModelOperation {
    private String projectName;
    private String templateId;
    private RequiredFacetVersion[] requiredFacetVersions;
    private String serverFactoryId;
    private String serverInstanceId;
    private org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime;

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        IStatus status;
        block15: {
            status = Status.OK_STATUS;
            status = this.checkDataReady();
            if (status.getSeverity() == 4) {
                return status;
            }
            IProject project = ProjectUtilities.getProject((String)this.projectName);
            if (!project.exists()) {
                try {
                    Set facetsToAdd;
                    status = FacetUtils.createNewFacetedProject(this.projectName);
                    if (status.getSeverity() == 4) {
                        return status;
                    }
                    IProject createdProject = ProjectUtilities.getProject((String)this.projectName);
                    IFacetedProject fproject = ProjectFacetsManager.create((IProject)createdProject);
                    status = FacetUtils.addFacetsToProject(fproject, facetsToAdd = this.getFacetsToAdd());
                    if (status.getSeverity() == 4) {
                        return status;
                    }
                    Set newFacetVersions = fproject.getProjectFacets();
                    HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
                    Iterator iter = newFacetVersions.iterator();
                    while (iter.hasNext()) {
                        IProjectFacetVersion facetVersion = (IProjectFacetVersion)iter.next();
                        fixedFacets.add(facetVersion.getProjectFacet());
                    }
                    status = FacetUtils.setFixedFacetsOnProject(fproject, fixedFacets);
                    if (status.getSeverity() == 4) {
                        return status;
                    }
                    if (this.facetRuntime != null) {
                        status = FacetUtils.setFacetRuntimeOnProject(fproject, this.facetRuntime);
                    }
                    if (this.requiredFacetVersions.length != 0 && (status = FacetUtils.addRequiredFacetsToProject(project, this.requiredFacetVersions, monitor)).getSeverity() == 4) {
                        return status;
                    }
                    if (this.facetRuntime == null) break block15;
                    Set projectFacetVersionSet = fproject.getProjectFacets();
                    HashSet<IProjectFacet> projectFacetSet = new HashSet<IProjectFacet>();
                    Iterator iter2 = projectFacetVersionSet.iterator();
                    while (iter2.hasNext()) {
                        IProjectFacetVersion pfv = (IProjectFacetVersion)iter2.next();
                        projectFacetSet.add(pfv.getProjectFacet());
                    }
                    try {
                        Set defaultProjectFacetVersionSet = this.facetRuntime.getDefaultFacets(projectFacetSet);
                        HashSet<IProjectFacetVersion> defaultFacetsToAdd = new HashSet<IProjectFacetVersion>();
                        Iterator iter3 = defaultProjectFacetVersionSet.iterator();
                        while (iter3.hasNext()) {
                            IProjectFacetVersion defaultProjFacetVersion = (IProjectFacetVersion)iter3.next();
                            if (projectFacetSet.contains(defaultProjFacetVersion.getProjectFacet())) continue;
                            defaultFacetsToAdd.add(defaultProjFacetVersion);
                        }
                        if (!defaultFacetsToAdd.isEmpty() && (status = FacetUtils.addFacetsToProject(fproject, defaultFacetsToAdd)).getSeverity() == 4) {
                            return status;
                        }
                    }
                    catch (CoreException coreException) {}
                }
                catch (CoreException coreException) {
                    return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_CREATION, (Object[])new String[]{this.projectName}));
                }
            }
        }
        return status;
    }

    private IStatus checkDataReady() {
        if (this.projectName == null) {
            return StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_CREATION, (Object[])new String[]{this.projectName}));
        }
        return Status.OK_STATUS;
    }

    private Set getFacetsToAdd() {
        FacetMatcher fm;
        Set combination;
        int i;
        Set facets = null;
        this.setFacetRuntime();
        Set[] allCombinations = FacetSetsByTemplateCache.getInstance().getFacetVersionCombinationsFromTemplate(this.templateId);
        int n = allCombinations.length;
        Set defaultFacets = FacetUtils.getDefaultFacetVersionsFromTemplate(this.templateId);
        int defaultIndex = n - 1;
        if (!defaultFacets.isEmpty()) {
            i = n - 1;
            while (i >= 0) {
                Set combo = allCombinations[i];
                if (combo.equals(defaultFacets)) {
                    defaultIndex = i;
                    break;
                }
                --i;
            }
        } else {
            defaultFacets = FacetUtils.getInitialFacetVersionsFromTemplate(this.templateId);
        }
        i = defaultIndex;
        while (i < n) {
            combination = allCombinations[i];
            fm = FacetUtils.match(this.requiredFacetVersions, combination);
            if (fm.isMatch()) {
                if (this.facetRuntime != null) {
                    if (FacetUtils.doesRuntimeSupportFacets(this.facetRuntime, combination)) {
                        facets = combination;
                        break;
                    }
                } else {
                    facets = combination;
                    break;
                }
            }
            ++i;
        }
        if (facets == null) {
            i = defaultIndex - 1;
            while (i >= 0) {
                combination = allCombinations[i];
                fm = FacetUtils.match(this.requiredFacetVersions, combination);
                if (fm.isMatch()) {
                    if (this.facetRuntime != null) {
                        if (FacetUtils.doesRuntimeSupportFacets(this.facetRuntime, combination)) {
                            facets = combination;
                            break;
                        }
                    } else {
                        facets = combination;
                        break;
                    }
                }
                --i;
            }
        }
        if (facets == null) {
            facets = defaultFacets;
        }
        return facets;
    }

    private void setFacetRuntime() {
        if (this.serverInstanceId != null && this.serverInstanceId.length() > 0) {
            IServer server = ServerCore.findServer((String)this.serverInstanceId);
            IRuntime sRuntime = server.getRuntime();
            this.facetRuntime = FacetUtil.getRuntime((IRuntime)sRuntime);
        } else if (this.serverFactoryId != null && this.serverFactoryId.length() > 0) {
            IRuntime serverRuntime = ServerUtils.getNonStubRuntime((String)this.serverFactoryId);
            if (serverRuntime != null) {
                this.facetRuntime = FacetUtil.getRuntime((IRuntime)serverRuntime);
            } else {
                IServerType st = ServerCore.findServerType((String)this.serverFactoryId);
                String runtimeTypeId = st.getRuntimeType().getId();
                IRuntime[] runtimes = ServerCore.getRuntimes();
                int i = 0;
                while (i < runtimes.length) {
                    IRuntime sRuntime = runtimes[i];
                    if (sRuntime.getRuntimeType().getId().equals(runtimeTypeId)) {
                        this.facetRuntime = FacetUtil.getRuntime((IRuntime)sRuntime);
                    }
                    ++i;
                }
            }
        }
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setRequiredFacetVersions(RequiredFacetVersion[] requiredFacetVersions) {
        this.requiredFacetVersions = requiredFacetVersions;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId = serverFactoryId;
    }

    public void setServerInstanceId(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }
}

