/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.utility.internal.Filter;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringIterator<E>
implements Iterator<E> {
    private final Iterator<?> nestedIterator;
    private final Filter filter;
    private E next;
    private boolean done;

    public FilteringIterator(Iterator<?> nestedIterator) {
        this(nestedIterator, Filter.Null.instance());
    }

    public FilteringIterator(Iterator<?> nestedIterator, Filter filter) {
        this.nestedIterator = nestedIterator;
        this.filter = filter;
        this.loadNext();
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public E next() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        E result = this.next;
        this.loadNext();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void loadNext() {
        this.done = true;
        while (this.nestedIterator.hasNext() && this.done) {
            Object o = this.nestedIterator.next();
            if (this.accept(o)) {
                this.next = o;
                this.done = false;
                continue;
            }
            this.next = null;
            this.done = true;
        }
    }

    protected boolean accept(Object o) {
        return this.filter.accept(o);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.nestedIterator);
    }
}

