/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.project.facet;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.project.facet.WtpUtils;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathContainerUtils;
import org.eclipse.jst.jee.project.facet.JEEFacetInstallDelegate;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class AppClientFacetInstallDelegate
extends JEEFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            try {
                IDataModel model = (IDataModel)config;
                IJavaProject jproj = JavaCore.create((IProject)project);
                WtpUtils.addNatures((IProject)project);
                this.createFlexibleProject(monitor, project, model, jproj);
                ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
                ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
                if (J2EEComponentClasspathContainerUtils.getDefaultUseEARLibraries()) {
                    Path earLibContainer = new Path("org.eclipse.jst.j2ee.internal.module.container");
                    AppClientFacetInstallDelegate.addToClasspath((IJavaProject)jproj, (IClasspathEntry)JavaCore.newContainerEntry((IPath)earLibContainer));
                }
                try {
                    ((IDataModelOperation)model.getProperty("FacetDataModelProvider.NOTIFICATION_OPERATION")).execute(monitor, null);
                }
                catch (ExecutionException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected IVirtualComponent createFlexibleProject(IProgressMonitor monitor, IProject project, IDataModel model, IJavaProject jproj) throws Exception {
        IFile appClientFile;
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IPath pjpath = project.getFullPath();
        IVirtualComponent c = ComponentCore.createComponent((IProject)project);
        c.create(0, null);
        this.setOutputFolder(model, c);
        IVirtualFolder root = c.getRootFolder();
        IFolder sourceFolder = null;
        String configFolder = null;
        configFolder = model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
        root.createLink((IPath)new Path("/" + configFolder), 0, null);
        String configFolderName = model.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
        IPath configFolderpath = pjpath.append(configFolderName);
        sourceFolder = ws.getRoot().getFolder(configFolderpath);
        if (model.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD") && !(appClientFile = sourceFolder.getFile((IPath)new Path("META-INF/application-client.xml"))).exists()) {
            try {
                if (!appClientFile.getParent().exists() && appClientFile.getParent().getType() == 2) {
                    ((IFolder)appClientFile.getParent()).create(true, true, monitor);
                }
                appClientFile.create((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<application-client version=\"5\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application-client_5.xsd\">\n</application-client>".getBytes("UTF-8")), true, monitor);
            }
            catch (UnsupportedEncodingException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        IClasspathEntry[] cp = jproj.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            IClasspathEntry cpe = cp[i];
            if (cpe.getEntryKind() == 3) {
                root.createLink(cpe.getPath().removeFirstSegments(1), 0, null);
            }
            ++i;
        }
        return c;
    }
}

