/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.content.java.JavaEObject;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaUniqueConstraint;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.mappings.ITable;
import org.eclipse.jpt.core.internal.mappings.IUniqueConstraint;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.utility.internal.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTable
extends JavaEObject
implements ITable {
    protected static final String NAME_EDEFAULT = null;
    protected static final String SPECIFIED_NAME_EDEFAULT = null;
    protected String specifiedName = SPECIFIED_NAME_EDEFAULT;
    protected static final String DEFAULT_NAME_EDEFAULT = null;
    protected String defaultName = DEFAULT_NAME_EDEFAULT;
    protected static final String CATALOG_EDEFAULT = null;
    protected static final String SPECIFIED_CATALOG_EDEFAULT = null;
    protected String specifiedCatalog = SPECIFIED_CATALOG_EDEFAULT;
    protected static final String DEFAULT_CATALOG_EDEFAULT = null;
    protected String defaultCatalog = DEFAULT_CATALOG_EDEFAULT;
    protected static final String SCHEMA_EDEFAULT = null;
    protected static final String SPECIFIED_SCHEMA_EDEFAULT = null;
    protected String specifiedSchema = SPECIFIED_SCHEMA_EDEFAULT;
    protected static final String DEFAULT_SCHEMA_EDEFAULT = null;
    protected String defaultSchema = DEFAULT_SCHEMA_EDEFAULT;
    protected EList<IUniqueConstraint> uniqueConstraints;
    private final ITable.Owner owner;
    private final Member member;
    private final DeclarationAnnotationAdapter daa;
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private final DeclarationAnnotationElementAdapter<String> schemaDeclarationAdapter;
    private final DeclarationAnnotationElementAdapter<String> catalogDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter;
    private final AnnotationElementAdapter<String> schemaAdapter;
    private final AnnotationElementAdapter<String> catalogAdapter;

    protected AbstractJavaTable() {
        throw new UnsupportedOperationException("Use AbstractJavaTable(Owner, Member) instead");
    }

    protected AbstractJavaTable(ITable.Owner owner, Member member, DeclarationAnnotationAdapter daa) {
        this.owner = owner;
        this.member = member;
        this.daa = daa;
        this.nameDeclarationAdapter = this.nameAdapter(daa);
        this.schemaDeclarationAdapter = this.schemaAdapter(daa);
        this.catalogDeclarationAdapter = this.catalogAdapter(daa);
        this.nameAdapter = new ShortCircuitAnnotationElementAdapter<String>(this.member, this.nameDeclarationAdapter);
        this.schemaAdapter = new ShortCircuitAnnotationElementAdapter<String>(this.member, this.schemaDeclarationAdapter);
        this.catalogAdapter = new ShortCircuitAnnotationElementAdapter<String>(this.member, this.catalogDeclarationAdapter);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> nameAdapter(DeclarationAnnotationAdapter var1);

    protected abstract DeclarationAnnotationElementAdapter<String> schemaAdapter(DeclarationAnnotationAdapter var1);

    protected abstract DeclarationAnnotationElementAdapter<String> catalogAdapter(DeclarationAnnotationAdapter var1);

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(ITable.class)) {
            case 1: {
                this.nameAdapter.setValue((String)notification.getNewValue());
                break;
            }
            case 7: {
                this.schemaAdapter.setValue((String)notification.getNewValue());
                break;
            }
            case 4: {
                this.catalogAdapter.setValue((String)notification.getNewValue());
                break;
            }
            case 9: {
                this.uniqueConstraintsChanged(notification);
                break;
            }
        }
    }

    void uniqueConstraintsChanged(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                this.uniqueConstraintAdded(notification.getPosition(), (IUniqueConstraint)notification.getNewValue());
                break;
            }
            case 5: {
                this.uniqueConstraintsAdded(notification.getPosition(), (List)notification.getNewValue());
                break;
            }
            case 4: {
                this.uniqueConstraintRemoved(notification.getPosition(), (IUniqueConstraint)notification.getOldValue());
                break;
            }
            case 6: {
                if (notification.getPosition() == -1) {
                    this.uniqueConstraintsCleared((List)notification.getOldValue());
                    break;
                }
                this.uniqueConstraintsRemoved((int[])notification.getNewValue(), (List)notification.getOldValue());
                break;
            }
            case 1: {
                if (notification.isTouch()) break;
                this.uniqueConstraintSet(notification.getPosition(), (IUniqueConstraint)notification.getOldValue(), (IUniqueConstraint)notification.getNewValue());
                break;
            }
            case 7: {
                this.uniqueConstraintMoved(notification.getOldIntValue(), notification.getPosition(), (IUniqueConstraint)notification.getNewValue());
                break;
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.ABSTRACT_JAVA_TABLE;
    }

    @Override
    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldSpecifiedName, (Object)this.specifiedName));
        }
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    @Override
    public String getCatalog() {
        return this.getSpecifiedCatalog() == null ? this.getDefaultCatalog() : this.getSpecifiedCatalog();
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String newSpecifiedCatalog) {
        String oldSpecifiedCatalog = this.specifiedCatalog;
        this.specifiedCatalog = newSpecifiedCatalog;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldSpecifiedCatalog, (Object)this.specifiedCatalog));
        }
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    @Override
    public String getSchema() {
        return this.getSpecifiedSchema() == null ? this.getDefaultSchema() : this.getSpecifiedSchema();
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String newSpecifiedSchema) {
        String oldSpecifiedSchema = this.specifiedSchema;
        this.specifiedSchema = newSpecifiedSchema;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldSpecifiedSchema, (Object)this.specifiedSchema));
        }
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Override
    public EList<IUniqueConstraint> getUniqueConstraints() {
        if (this.uniqueConstraints == null) {
            this.uniqueConstraints = new EObjectContainmentEList(IUniqueConstraint.class, (InternalEObject)this, 9);
        }
        return this.uniqueConstraints;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getUniqueConstraints()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getSpecifiedName();
            }
            case 2: {
                return this.getDefaultName();
            }
            case 3: {
                return this.getCatalog();
            }
            case 4: {
                return this.getSpecifiedCatalog();
            }
            case 5: {
                return this.getDefaultCatalog();
            }
            case 6: {
                return this.getSchema();
            }
            case 7: {
                return this.getSpecifiedSchema();
            }
            case 8: {
                return this.getDefaultSchema();
            }
            case 9: {
                return this.getUniqueConstraints();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setSpecifiedName((String)newValue);
                return;
            }
            case 4: {
                this.setSpecifiedCatalog((String)newValue);
                return;
            }
            case 7: {
                this.setSpecifiedSchema((String)newValue);
                return;
            }
            case 9: {
                this.getUniqueConstraints().clear();
                this.getUniqueConstraints().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setSpecifiedName(SPECIFIED_NAME_EDEFAULT);
                return;
            }
            case 4: {
                this.setSpecifiedCatalog(SPECIFIED_CATALOG_EDEFAULT);
                return;
            }
            case 7: {
                this.setSpecifiedSchema(SPECIFIED_SCHEMA_EDEFAULT);
                return;
            }
            case 9: {
                this.getUniqueConstraints().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.getName() != null : !NAME_EDEFAULT.equals(this.getName());
            }
            case 1: {
                return SPECIFIED_NAME_EDEFAULT == null ? this.specifiedName != null : !SPECIFIED_NAME_EDEFAULT.equals(this.specifiedName);
            }
            case 2: {
                return DEFAULT_NAME_EDEFAULT == null ? this.defaultName != null : !DEFAULT_NAME_EDEFAULT.equals(this.defaultName);
            }
            case 3: {
                return CATALOG_EDEFAULT == null ? this.getCatalog() != null : !CATALOG_EDEFAULT.equals(this.getCatalog());
            }
            case 4: {
                return SPECIFIED_CATALOG_EDEFAULT == null ? this.specifiedCatalog != null : !SPECIFIED_CATALOG_EDEFAULT.equals(this.specifiedCatalog);
            }
            case 5: {
                return DEFAULT_CATALOG_EDEFAULT == null ? this.defaultCatalog != null : !DEFAULT_CATALOG_EDEFAULT.equals(this.defaultCatalog);
            }
            case 6: {
                return SCHEMA_EDEFAULT == null ? this.getSchema() != null : !SCHEMA_EDEFAULT.equals(this.getSchema());
            }
            case 7: {
                return SPECIFIED_SCHEMA_EDEFAULT == null ? this.specifiedSchema != null : !SPECIFIED_SCHEMA_EDEFAULT.equals(this.specifiedSchema);
            }
            case 8: {
                return DEFAULT_SCHEMA_EDEFAULT == null ? this.defaultSchema != null : !DEFAULT_SCHEMA_EDEFAULT.equals(this.defaultSchema);
            }
            case 9: {
                return this.uniqueConstraints != null && !this.uniqueConstraints.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == ITable.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
                case 6: {
                    return 6;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 8;
                }
                case 9: {
                    return 9;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == ITable.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
                case 6: {
                    return 6;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 8;
                }
                case 9: {
                    return 9;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (specifiedName: ");
        result.append(this.specifiedName);
        result.append(", defaultName: ");
        result.append(this.defaultName);
        result.append(", specifiedCatalog: ");
        result.append(this.specifiedCatalog);
        result.append(", defaultCatalog: ");
        result.append(this.defaultCatalog);
        result.append(", specifiedSchema: ");
        result.append(this.specifiedSchema);
        result.append(", defaultSchema: ");
        result.append(this.defaultSchema);
        result.append(')');
        return result.toString();
    }

    @Override
    public ITextRange nameTextRange() {
        return this.elementTextRange(this.nameDeclarationAdapter);
    }

    public ITextRange nameTextRange(CompilationUnit astRoot) {
        return this.elementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.nameDeclarationAdapter, pos, astRoot);
    }

    @Override
    public ITextRange schemaTextRange() {
        return this.elementTextRange(this.schemaDeclarationAdapter);
    }

    public ITextRange schemaTextRange(CompilationUnit astRoot) {
        return this.elementTextRange(this.schemaDeclarationAdapter, astRoot);
    }

    public boolean schemaTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.schemaDeclarationAdapter, pos, astRoot);
    }

    public ITextRange catalogTextRange() {
        return this.elementTextRange(this.catalogDeclarationAdapter);
    }

    public ITextRange catalogTextRange(CompilationUnit astRoot) {
        return this.elementTextRange(this.catalogDeclarationAdapter, astRoot);
    }

    public boolean catalogTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.catalogDeclarationAdapter, pos, astRoot);
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldDefaultName, (Object)this.defaultName));
        }
    }

    protected void setDefaultCatalog(String newDefaultCatalog) {
        String oldDefaultCatalog = this.defaultCatalog;
        this.defaultCatalog = newDefaultCatalog;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldDefaultCatalog, (Object)this.defaultCatalog));
        }
    }

    protected void setDefaultSchema(String newDefaultSchema) {
        String oldDefaultSchema = this.defaultSchema;
        this.defaultSchema = newDefaultSchema;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldDefaultSchema, (Object)this.defaultSchema));
        }
    }

    @Override
    public ITable.Owner getOwner() {
        return this.owner;
    }

    protected Member getMember() {
        return this.member;
    }

    protected DeclarationAnnotationAdapter getDeclarationAnnotationAdapter() {
        return this.daa;
    }

    @Override
    public IUniqueConstraint createUniqueConstraint(int index) {
        return this.createJavaUniqueConstraint(index);
    }

    protected abstract JavaUniqueConstraint createJavaUniqueConstraint(int var1);

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        this.setDefaultCatalog((String)defaultsContext.getDefault("table.catalog"));
        this.setDefaultSchema((String)defaultsContext.getDefault("table.schema"));
    }

    protected void updateFromJava(CompilationUnit astRoot) {
        this.setSpecifiedName(this.nameAdapter.getValue(astRoot));
        this.setSpecifiedSchema(this.schemaAdapter.getValue(astRoot));
        this.setSpecifiedCatalog(this.catalogAdapter.getValue(astRoot));
        this.updateUniqueConstraintsFromJava(astRoot);
    }

    /*
     * Unable to fully structure code
     */
    private void updateUniqueConstraintsFromJava(CompilationUnit astRoot) {
        block5: {
            constraints = this.getUniqueConstraints();
            persSize = constraints.size();
            javaSize = 0;
            allJavaAnnotationsFound = false;
            i = 0;
            while (i < persSize) {
                uniqueConstraint = (JavaUniqueConstraint)constraints.get(i);
                if (uniqueConstraint.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    break;
                }
                uniqueConstraint.updateFromJava(astRoot);
                ++javaSize;
                ++i;
            }
            if (!allJavaAnnotationsFound) ** GOTO lbl29
            while (persSize > javaSize) {
                constraints.remove(--persSize);
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                uniqueConstraint = this.createJavaUniqueConstraint(javaSize);
                if (uniqueConstraint.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    continue;
                }
                this.getUniqueConstraints().add((Object)uniqueConstraint);
                uniqueConstraint.updateFromJava(astRoot);
                ++javaSize;
lbl29:
                // 3 sources

                ** while (!allJavaAnnotationsFound)
            }
        }
    }

    @Override
    public ITextRange validationTextRange() {
        ITextRange textRange = this.member.annotationTextRange(this.daa);
        return textRange != null ? textRange : this.getOwner().validationTextRange();
    }

    @Override
    public Table dbTable() {
        Schema schema = this.dbSchema();
        return schema == null ? null : schema.tableNamed(this.getName());
    }

    @Override
    public Schema dbSchema() {
        return this.database().schemaNamed(this.getSchema());
    }

    @Override
    public boolean hasResolvedSchema() {
        return this.dbSchema() != null;
    }

    @Override
    public boolean isResolved() {
        return this.dbTable() != null;
    }

    protected ITextRange elementTextRange(DeclarationAnnotationElementAdapter<?> elementAdapter) {
        return this.elementTextRange(this.member.annotationElementTextRange(elementAdapter));
    }

    protected ITextRange elementTextRange(DeclarationAnnotationElementAdapter<?> elementAdapter, CompilationUnit astRoot) {
        return this.elementTextRange(this.member.annotationElementTextRange(elementAdapter, astRoot));
    }

    protected boolean elementTouches(DeclarationAnnotationElementAdapter<?> elementAdapter, int pos) {
        return this.elementTouches(this.member.annotationElementTextRange(elementAdapter), pos);
    }

    protected boolean elementTouches(DeclarationAnnotationElementAdapter<?> elementAdapter, int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.member.annotationElementTextRange(elementAdapter, astRoot), pos);
    }

    @Override
    public Iterator<String> candidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (IUniqueConstraint constraint : this.getUniqueConstraints()) {
            result = ((JavaUniqueConstraint)constraint).candidateValuesFor(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Iterator<String> connectedCandidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedCandidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.nameTouches(pos, astRoot)) {
            return this.quotedCandidateNames(filter);
        }
        if (this.schemaTouches(pos, astRoot)) {
            return this.quotedCandidateSchemas(filter);
        }
        if (this.catalogTouches(pos, astRoot)) {
            return this.quotedCandidateCatalogs(filter);
        }
        return null;
    }

    private Iterator<String> candidateNames() {
        Schema dbSchema = this.dbSchema();
        return dbSchema != null ? dbSchema.tableNames() : EmptyIterator.instance();
    }

    private Iterator<String> candidateNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateNames(), filter);
    }

    private Iterator<String> quotedCandidateNames(Filter<String> filter) {
        return StringTools.quote(this.candidateNames(filter));
    }

    private Iterator<String> candidateSchemas() {
        return this.database().schemaNames();
    }

    private Iterator<String> candidateSchemas(Filter<String> filter) {
        return new FilteringIterator(this.candidateSchemas(), filter);
    }

    private Iterator<String> quotedCandidateSchemas(Filter<String> filter) {
        return StringTools.quote(this.candidateSchemas(filter));
    }

    private Iterator<String> candidateCatalogs() {
        return this.database().catalogNames();
    }

    private Iterator<String> candidateCatalogs(Filter<String> filter) {
        return new FilteringIterator(this.candidateCatalogs(), filter);
    }

    private Iterator<String> quotedCandidateCatalogs(Filter<String> filter) {
        return StringTools.quote(this.candidateCatalogs(filter));
    }

    public void uniqueConstraintAdded(int index, IUniqueConstraint uniqueConstraint) {
        if (((JavaUniqueConstraint)uniqueConstraint).annotation(this.getMember().astRoot()) == null) {
            this.synchUniqueConstraintAnnotationsAfterAdd(index + 1);
            ((JavaUniqueConstraint)uniqueConstraint).newAnnotation();
        }
    }

    public void uniqueConstraintsAdded(int index, List<IUniqueConstraint> constraints) {
        if (!constraints.isEmpty() && ((JavaUniqueConstraint)constraints.get(0)).annotation(this.getMember().astRoot()) == null) {
            this.synchUniqueConstraintAnnotationsAfterAdd(index + constraints.size());
            for (IUniqueConstraint uniqueConstraint : constraints) {
                ((JavaUniqueConstraint)uniqueConstraint).newAnnotation();
            }
        }
    }

    public void uniqueConstraintRemoved(int index, IUniqueConstraint uniqueConstraint) {
        ((JavaUniqueConstraint)uniqueConstraint).removeAnnotation();
        this.synchUniqueConstraintAnnotationsAfterRemove(index);
    }

    public void uniqueConstraintsRemoved(int[] indexes, List<IUniqueConstraint> constraints) {
        for (IUniqueConstraint uniqueConstraint : constraints) {
            ((JavaUniqueConstraint)uniqueConstraint).removeAnnotation();
        }
        this.synchUniqueConstraintAnnotationsAfterRemove(indexes[0]);
    }

    public void uniqueConstraintsCleared(List<IUniqueConstraint> constraints) {
        for (IUniqueConstraint uniqueConstraint : constraints) {
            ((JavaUniqueConstraint)uniqueConstraint).removeAnnotation();
        }
    }

    public void uniqueConstraintSet(int index, IUniqueConstraint oldUniqueConstraint, IUniqueConstraint newUniqueConstraint) {
        ((JavaUniqueConstraint)newUniqueConstraint).newAnnotation();
    }

    public void uniqueConstraintMoved(int sourceIndex, int targetIndex, IUniqueConstraint uniqueConstraint) {
        EList<IUniqueConstraint> constraints = this.getUniqueConstraints();
        int begin = Math.min(sourceIndex, targetIndex);
        int end = Math.max(sourceIndex, targetIndex);
        int i = begin;
        while (i-- > end) {
            this.synch((IUniqueConstraint)constraints.get(i), i);
        }
    }

    private void synchUniqueConstraintAnnotationsAfterAdd(int index) {
        EList<IUniqueConstraint> constraints = this.getUniqueConstraints();
        int i = constraints.size();
        while (i-- > index) {
            this.synch((IUniqueConstraint)constraints.get(i), i);
        }
    }

    private void synchUniqueConstraintAnnotationsAfterRemove(int index) {
        EList<IUniqueConstraint> joinColumns = this.getUniqueConstraints();
        int i = index;
        while (i < joinColumns.size()) {
            this.synch((IUniqueConstraint)joinColumns.get(i), i);
            ++i;
        }
    }

    private void synch(IUniqueConstraint uniqueConstraint, int index) {
        ((JavaUniqueConstraint)uniqueConstraint).moveAnnotation(index);
    }
}

