/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.core.internal.content.java.IJavaAttributeMapping;
import org.eclipse.jpt.core.internal.content.java.IJavaAttributeMappingProvider;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaBasic;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsFactory;
import org.eclipse.jpt.core.internal.jdtutility.Attribute;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.utility.internal.CollectionTools;

public class JavaBasicProvider
implements IJavaAttributeMappingProvider {
    private static final JavaBasicProvider INSTANCE = new JavaBasicProvider();
    private static final String[] VALID_ELEMENT_TYPE_NAMES = new String[]{Byte.TYPE.getName(), Character.TYPE.getName(), Byte.class.getName(), Character.class.getName()};
    private static final String[] PRIMITIVE_WRAPPER_TYPE_NAMES = new String[]{Byte.class.getName(), Character.class.getName(), Double.class.getName(), Float.class.getName(), Integer.class.getName(), Long.class.getName(), Short.class.getName(), Boolean.class.getName()};
    private static final String[] OTHER_SUPPORTED_TYPE_NAMES = new String[]{String.class.getName(), BigInteger.class.getName(), BigDecimal.class.getName(), java.util.Date.class.getName(), Calendar.class.getName(), Date.class.getName(), Time.class.getName(), Timestamp.class.getName()};
    private static final String SERIALIZABLE_TYPE_NAME = Serializable.class.getName();

    public static IJavaAttributeMappingProvider instance() {
        return INSTANCE;
    }

    private JavaBasicProvider() {
    }

    public String key() {
        return "basic";
    }

    public boolean defaultApplies(Attribute attribute, DefaultsContext defaultsContext) {
        CompilationUnit astRoot = defaultsContext.astRoot();
        return JavaBasicProvider.typeIsBasic(attribute.typeBinding(astRoot), astRoot.getAST());
    }

    public IJavaAttributeMapping buildMapping(Attribute attribute) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaBasic(attribute);
    }

    public DeclarationAnnotationAdapter declarationAnnotationAdapter() {
        return JavaBasic.DECLARATION_ANNOTATION_ADAPTER;
    }

    public static boolean typeIsBasic(ITypeBinding typeBinding, AST ast) {
        if (typeBinding == null) {
            return false;
        }
        if (typeBinding.isPrimitive()) {
            return true;
        }
        if (typeBinding.isArray()) {
            if (typeBinding.getDimensions() > 1) {
                return false;
            }
            ITypeBinding elementTypeBinding = typeBinding.getElementType();
            if (elementTypeBinding == null) {
                return false;
            }
            return JavaBasicProvider.elementTypeIsValid(elementTypeBinding.getQualifiedName());
        }
        String typeName = typeBinding.getQualifiedName();
        if (JavaBasicProvider.typeIsPrimitiveWrapper(typeName)) {
            return true;
        }
        if (JavaBasicProvider.typeIsOtherSupportedType(typeName)) {
            return true;
        }
        if (typeBinding.isEnum()) {
            return true;
        }
        return JavaBasicProvider.typeImplementsSerializable(typeBinding, ast);
    }

    private static boolean elementTypeIsValid(String elementTypeName) {
        return CollectionTools.contains((Object[])VALID_ELEMENT_TYPE_NAMES, (Object)elementTypeName);
    }

    private static boolean typeIsPrimitiveWrapper(String typeName) {
        return CollectionTools.contains((Object[])PRIMITIVE_WRAPPER_TYPE_NAMES, (Object)typeName);
    }

    private static boolean typeIsOtherSupportedType(String typeName) {
        return CollectionTools.contains((Object[])OTHER_SUPPORTED_TYPE_NAMES, (Object)typeName);
    }

    private static boolean typeImplementsSerializable(ITypeBinding typeBinding, AST ast) {
        ITypeBinding serializableTypeBinding = ast.resolveWellKnownType(SERIALIZABLE_TYPE_NAME);
        return typeBinding.isAssignmentCompatible(serializableTypeBinding);
    }
}

