/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.content.java.mappings.AbstractJavaColumn;
import org.eclipse.jpt.core.internal.content.java.mappings.IntAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsFactory;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.NestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.mappings.IColumn;
import org.eclipse.jpt.core.internal.mappings.INamedColumn;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaColumn
extends AbstractJavaColumn
implements IColumn {
    protected static final int LENGTH_EDEFAULT = 0;
    protected static final int SPECIFIED_LENGTH_EDEFAULT = -1;
    protected int specifiedLength = -1;
    protected static final int PRECISION_EDEFAULT = 0;
    protected static final int SPECIFIED_PRECISION_EDEFAULT = -1;
    protected int specifiedPrecision = -1;
    protected static final int SCALE_EDEFAULT = 0;
    protected static final int SPECIFIED_SCALE_EDEFAULT = -1;
    protected int specifiedScale = -1;
    private final IntAnnotationElementAdapter lengthAdapter;
    private final IntAnnotationElementAdapter precisionAdapter;
    private final IntAnnotationElementAdapter scaleAdapter;
    public static final SimpleDeclarationAnnotationAdapter MAPPING_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Column");

    protected JavaColumn() {
        throw new UnsupportedOperationException("Use JavaColumn(Owner, Member, DeclarationAnnotationAdapter) instead");
    }

    protected JavaColumn(INamedColumn.Owner owner, Member member, DeclarationAnnotationAdapter daa) {
        super(owner, member, daa);
        this.lengthAdapter = this.buildShortCircuitIntElementAdapter("length");
        this.precisionAdapter = this.buildShortCircuitIntElementAdapter("precision");
        this.scaleAdapter = this.buildShortCircuitIntElementAdapter("scale");
    }

    @Override
    protected String nameElementName() {
        return "name";
    }

    @Override
    protected String columnDefinitionElementName() {
        return "columnDefinition";
    }

    @Override
    protected String tableElementName() {
        return "table";
    }

    @Override
    protected String uniqueElementName() {
        return "unique";
    }

    @Override
    protected String nullableElementName() {
        return "nullable";
    }

    @Override
    protected String insertableElementName() {
        return "insertable";
    }

    @Override
    protected String updatableElementName() {
        return "updatable";
    }

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(IColumn.class)) {
            case 11: {
                this.lengthAdapter.setValue(notification.getNewIntValue());
                break;
            }
            case 13: {
                this.precisionAdapter.setValue(notification.getNewIntValue());
                break;
            }
            case 15: {
                this.scaleAdapter.setValue(notification.getNewIntValue());
                break;
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_COLUMN;
    }

    @Override
    public int getLength() {
        return this.getSpecifiedLength() == -1 ? this.getDefaultLength() : this.getSpecifiedLength();
    }

    @Override
    public int getSpecifiedLength() {
        return this.specifiedLength;
    }

    @Override
    public void setSpecifiedLength(int newSpecifiedLength) {
        int oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldSpecifiedLength, this.specifiedLength));
        }
    }

    @Override
    public int getPrecision() {
        return this.getSpecifiedPrecision() == -1 ? this.getDefaultPrecision() : this.getSpecifiedPrecision();
    }

    @Override
    public int getSpecifiedPrecision() {
        return this.specifiedPrecision;
    }

    @Override
    public void setSpecifiedPrecision(int newSpecifiedPrecision) {
        int oldSpecifiedPrecision = this.specifiedPrecision;
        this.specifiedPrecision = newSpecifiedPrecision;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, oldSpecifiedPrecision, this.specifiedPrecision));
        }
    }

    @Override
    public int getScale() {
        return this.getSpecifiedScale() == -1 ? this.getDefaultScale() : this.getSpecifiedScale();
    }

    @Override
    public int getSpecifiedScale() {
        return this.specifiedScale;
    }

    @Override
    public void setSpecifiedScale(int newSpecifiedScale) {
        int oldSpecifiedScale = this.specifiedScale;
        this.specifiedScale = newSpecifiedScale;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, oldSpecifiedScale, this.specifiedScale));
        }
    }

    @Override
    public int getDefaultLength() {
        return 255;
    }

    @Override
    public int getDefaultPrecision() {
        return 0;
    }

    @Override
    public int getDefaultScale() {
        return 0;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return new Integer(this.getLength());
            }
            case 12: {
                return new Integer(this.getSpecifiedLength());
            }
            case 13: {
                return new Integer(this.getPrecision());
            }
            case 14: {
                return new Integer(this.getSpecifiedPrecision());
            }
            case 15: {
                return new Integer(this.getScale());
            }
            case 16: {
                return new Integer(this.getSpecifiedScale());
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 12: {
                this.setSpecifiedLength((Integer)newValue);
                return;
            }
            case 14: {
                this.setSpecifiedPrecision((Integer)newValue);
                return;
            }
            case 16: {
                this.setSpecifiedScale((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 12: {
                this.setSpecifiedLength(-1);
                return;
            }
            case 14: {
                this.setSpecifiedPrecision(-1);
                return;
            }
            case 16: {
                this.setSpecifiedScale(-1);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return this.getLength() != 0;
            }
            case 12: {
                return this.specifiedLength != -1;
            }
            case 13: {
                return this.getPrecision() != 0;
            }
            case 14: {
                return this.specifiedPrecision != -1;
            }
            case 15: {
                return this.getScale() != 0;
            }
            case 16: {
                return this.specifiedScale != -1;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IColumn.class) {
            switch (derivedFeatureID) {
                case 11: {
                    return 11;
                }
                case 12: {
                    return 12;
                }
                case 13: {
                    return 13;
                }
                case 14: {
                    return 14;
                }
                case 15: {
                    return 15;
                }
                case 16: {
                    return 16;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IColumn.class) {
            switch (baseFeatureID) {
                case 11: {
                    return 11;
                }
                case 12: {
                    return 12;
                }
                case 13: {
                    return 13;
                }
                case 14: {
                    return 14;
                }
                case 15: {
                    return 15;
                }
                case 16: {
                    return 16;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (specifiedLength: ");
        result.append(this.specifiedLength);
        result.append(", specifiedPrecision: ");
        result.append(this.specifiedPrecision);
        result.append(", specifiedScale: ");
        result.append(this.specifiedScale);
        result.append(')');
        return result.toString();
    }

    @Override
    public boolean tableIsAllowed() {
        return true;
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.setSpecifiedLength(this.lengthAdapter.getValue(astRoot));
        this.setSpecifiedPrecision(this.precisionAdapter.getValue(astRoot));
        this.setSpecifiedScale(this.scaleAdapter.getValue(astRoot));
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext) {
        this.setDefaultTable((String)defaultsContext.getDefault("column.table"));
        this.setDefaultName((String)defaultsContext.getDefault("column.name"));
    }

    static JavaColumn createColumnMappingColumn(INamedColumn.Owner owner, Member member) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaColumn(owner, member, MAPPING_DECLARATION_ANNOTATION_ADAPTER);
    }

    static JavaColumn createAttributeOverrideColumn(INamedColumn.Owner owner, Member member, DeclarationAnnotationAdapter attributeOverrideAnnotationAdapter) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaColumn(owner, member, JavaColumn.buildAttributeOverrideAnnotationAdapter(attributeOverrideAnnotationAdapter));
    }

    private static DeclarationAnnotationAdapter buildAttributeOverrideAnnotationAdapter(DeclarationAnnotationAdapter attributeOverrideAnnotationAdapter) {
        return new NestedDeclarationAnnotationAdapter(attributeOverrideAnnotationAdapter, "column", "javax.persistence.Column");
    }
}

