/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.content.java.JavaEObject;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaJoinTable;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaTable;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaTableGenerator;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsFactory;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationStringArrayExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ShortCircuitArrayAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.mappings.IUniqueConstraint;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaUniqueConstraint
extends JavaEObject
implements IUniqueConstraint {
    protected EList<String> columnNames;
    private final IUniqueConstraint.Owner owner;
    private final Member member;
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.UniqueConstraint");
    private final IndexedDeclarationAnnotationAdapter idaa;
    private final IndexedAnnotationAdapter annotationAdapter;
    private final DeclarationAnnotationElementAdapter<String[]> columnNamesDeclarationAdapter;
    private final AnnotationElementAdapter<String[]> columnNamesAdapter;

    protected JavaUniqueConstraint() {
        throw new UnsupportedOperationException("Use JavaUniqueConstraint(IUniqueConstraint.Owner, Member, IndexedDeclarationAnnotationAdapter) instead");
    }

    protected JavaUniqueConstraint(IUniqueConstraint.Owner owner, Member member, IndexedDeclarationAnnotationAdapter idaa) {
        this.owner = owner;
        this.member = member;
        this.idaa = idaa;
        this.annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        this.columnNamesDeclarationAdapter = JavaUniqueConstraint.buildArrayAnnotationElementAdapter(idaa, "columnNames");
        this.columnNamesAdapter = this.buildAnnotationElementAdapter(this.columnNamesDeclarationAdapter);
    }

    protected AnnotationElementAdapter<String[]> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String[]> daea) {
        return new ShortCircuitArrayAnnotationElementAdapter(this.member, (DeclarationAnnotationElementAdapter<T[]>)daea);
    }

    protected static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return JavaUniqueConstraint.buildArrayAnnotationElementAdapter(annotationAdapter, elementName, AnnotationStringArrayExpressionConverter.forStrings());
    }

    protected static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String[]> converter) {
        return new ConversionDeclarationAnnotationElementAdapter<String[]>(annotationAdapter, elementName, false, converter);
    }

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(IUniqueConstraint.class)) {
            case 0: {
                this.columnNamesAdapter.setValue((String[])this.getColumnNames().toArray());
                break;
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_UNIQUE_CONSTRAINT;
    }

    @Override
    public EList<String> getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new EDataTypeEList(String.class, (InternalEObject)this, 0);
        }
        return this.columnNames;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getColumnNames();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getColumnNames().clear();
                this.getColumnNames().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getColumnNames().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.columnNames != null && !this.columnNames.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IUniqueConstraint.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IUniqueConstraint.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (columnNames: ");
        result.append(this.columnNames);
        result.append(')');
        return result.toString();
    }

    public IUniqueConstraint.Owner getOwner() {
        return this.owner;
    }

    @Override
    public ITextRange validationTextRange() {
        return this.member.annotationTextRange(this.idaa);
    }

    protected boolean elementTouches(DeclarationAnnotationElementAdapter<?> elementAdapter, int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.member.annotationElementTextRange(elementAdapter, astRoot), pos);
    }

    private boolean columnNamesTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.columnNamesDeclarationAdapter, pos, astRoot);
    }

    private Iterator<String> candidateColumnNames() {
        return this.getOwner().candidateUniqueConstraintColumnNames();
    }

    private Iterator<String> candidateColumnNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateColumnNames(), filter);
    }

    private Iterator<String> quotedCandidateColumnNames(Filter<String> filter) {
        return StringTools.quote(this.candidateColumnNames(filter));
    }

    @Override
    public Iterator<String> connectedCandidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedCandidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.columnNamesTouches(pos, astRoot)) {
            return this.quotedCandidateColumnNames(filter);
        }
        return null;
    }

    public Annotation annotation(CompilationUnit astRoot) {
        return this.annotationAdapter.getAnnotation(astRoot);
    }

    public void updateFromJava(CompilationUnit astRoot) {
        this.updateColumnNamesFromJava(astRoot);
    }

    private void updateColumnNamesFromJava(CompilationUnit astRoot) {
        Object[] javaColumnNames = this.columnNamesAdapter.getValue(astRoot);
        CollectionTools.retainAll(this.getColumnNames(), (Object[])javaColumnNames);
        int i = 0;
        while (i < javaColumnNames.length) {
            Object columnName = javaColumnNames[i];
            if (!this.getColumnNames().contains(columnName)) {
                this.getColumnNames().add(columnName);
            }
            ++i;
        }
    }

    void moveAnnotation(int newIndex) {
        this.annotationAdapter.moveAnnotation(newIndex);
    }

    void newAnnotation() {
        this.annotationAdapter.newMarkerAnnotation();
    }

    void removeAnnotation() {
        this.annotationAdapter.removeAnnotation();
    }

    static JavaUniqueConstraint createSecondaryTableUniqueConstraint(IUniqueConstraint.Owner owner, DeclarationAnnotationAdapter declarationAnnotationAdapter, Member member, int index) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaUniqueConstraint(owner, member, JavaUniqueConstraint.buildSecondaryTableUniqueConstraintAnnotationAdapter(declarationAnnotationAdapter, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildSecondaryTableUniqueConstraintAnnotationAdapter(DeclarationAnnotationAdapter declarationAnnotationAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(declarationAnnotationAdapter, "uniqueConstraints", index, "javax.persistence.UniqueConstraint");
    }

    static JavaUniqueConstraint createJoinTableUniqueConstraint(IUniqueConstraint.Owner owner, Member member, int index) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaUniqueConstraint(owner, member, JavaUniqueConstraint.buildJoinTableUniqueConstraintAnnotationAdapter(index));
    }

    private static IndexedDeclarationAnnotationAdapter buildJoinTableUniqueConstraintAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(JavaJoinTable.DECLARATION_ANNOTATION_ADAPTER, "uniqueConstraints", index, "javax.persistence.UniqueConstraint");
    }

    static JavaUniqueConstraint createTableUniqueConstraint(IUniqueConstraint.Owner owner, Member member, int index) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaUniqueConstraint(owner, member, JavaUniqueConstraint.buildTableUniqueConstraintAnnotationAdapter(index));
    }

    private static IndexedDeclarationAnnotationAdapter buildTableUniqueConstraintAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(JavaTable.DECLARATION_ANNOTATION_ADAPTER, "uniqueConstraints", index, "javax.persistence.UniqueConstraint");
    }

    static JavaUniqueConstraint createTableGeneratorUniqueConstraint(IUniqueConstraint.Owner owner, Member member, int index) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaUniqueConstraint(owner, member, JavaUniqueConstraint.buildTableGeneratorUniqueConstraintAnnotationAdapter(index));
    }

    private static IndexedDeclarationAnnotationAdapter buildTableGeneratorUniqueConstraintAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(JavaTableGenerator.DECLARATION_ANNOTATION_ADAPTER, "uniqueConstraints", index, "javax.persistence.UniqueConstraint");
    }
}

