/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.internal.facet.IJpaFacetDataModelProperties;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JpaFacetInstallDelegate
implements IDelegate,
IJpaFacetDataModelProperties {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        boolean usesServerLibrary = ((IDataModel)config).getBooleanProperty("IJpaFacetDataModelProperties.USE_SERVER_JPA_IMPLEMENTATION");
        String jpaLibrary = ((IDataModel)config).getStringProperty("IJpaFacetDataModelProperties.JPA_LIBRARY");
        if (!usesServerLibrary && !StringTools.stringIsEmpty((String)jpaLibrary)) {
            IClasspathEntry[] classpath = javaProject.getRawClasspath();
            int newLength = classpath.length + 1;
            boolean isWebApp = FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jst.web");
            IClasspathAttribute[] attributes = !isWebApp && J2EEProjectUtilities.isStandaloneProject((IProject)project) ? new IClasspathAttribute[]{} : new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.dependency", (String)ClasspathDependencyUtil.getDefaultRuntimePath((boolean)isWebApp).toString())};
            IClasspathEntry jpaLibraryEntry = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.USER_LIBRARY/" + jpaLibrary), null, (IClasspathAttribute[])attributes, (boolean)true);
            IClasspathEntry[] newClasspath = new IClasspathEntry[newLength];
            System.arraycopy(classpath, 0, newClasspath, 0, newLength - 1);
            newClasspath[newLength - 1] = jpaLibraryEntry;
            javaProject.setRawClasspath(newClasspath, monitor);
        }
        if (monitor != null) {
            monitor.worked(1);
        }
    }
}

