/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.internal.jdtutility.BooleanStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.CharacterStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.ExpressionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ModifiedDeclaration;
import org.eclipse.jpt.core.internal.jdtutility.NumberStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.StringExpressionConverter;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionDeclarationAnnotationElementAdapter<T>
implements DeclarationAnnotationElementAdapter<T> {
    private final DeclarationAnnotationElementAdapter<Expression> adapter;
    private final ExpressionConverter<T> converter;

    public ConversionDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, ExpressionConverter<T> converter) {
        this(new ExpressionDeclarationAnnotationElementAdapter<Expression>(annotationAdapter), converter);
    }

    public ConversionDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<T> converter) {
        this(new ExpressionDeclarationAnnotationElementAdapter<Expression>(annotationAdapter, elementName), converter);
    }

    public ConversionDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, boolean removeAnnotationWhenEmpty, ExpressionConverter<T> converter) {
        this(new ExpressionDeclarationAnnotationElementAdapter<Expression>(annotationAdapter, elementName, removeAnnotationWhenEmpty), converter);
    }

    public ConversionDeclarationAnnotationElementAdapter(DeclarationAnnotationElementAdapter<Expression> adapter, ExpressionConverter<T> converter) {
        this.adapter = adapter;
        this.converter = converter;
    }

    @Override
    public T getValue(ModifiedDeclaration declaration) {
        Expression expression = this.adapter.getValue(declaration);
        return this.converter.convert(expression);
    }

    @Override
    public void setValue(T value, ModifiedDeclaration declaration) {
        Expression expression;
        try {
            expression = this.converter.convert(value, declaration.getAST());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        this.adapter.setValue(expression, declaration);
    }

    @Override
    public Expression expression(ModifiedDeclaration declaration) {
        return this.adapter.expression(declaration);
    }

    @Override
    public ASTNode astNode(ModifiedDeclaration declaration) {
        return this.adapter.astNode(declaration);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.adapter);
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forStrings(DeclarationAnnotationAdapter annotationAdapter) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, StringExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forStrings(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, StringExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forStrings(DeclarationAnnotationAdapter annotationAdapter, String elementName, boolean removeAnnotationWhenEmpty) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, removeAnnotationWhenEmpty, StringExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forNumbers(DeclarationAnnotationAdapter annotationAdapter) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, NumberStringExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forNumbers(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, NumberStringExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forNumbers(DeclarationAnnotationAdapter annotationAdapter, String elementName, boolean removeAnnotationWhenEmpty) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, removeAnnotationWhenEmpty, NumberStringExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forBooleans(DeclarationAnnotationAdapter annotationAdapter) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, BooleanStringExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forBooleans(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, BooleanStringExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forBooleans(DeclarationAnnotationAdapter annotationAdapter, String elementName, boolean removeAnnotationWhenEmpty) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, removeAnnotationWhenEmpty, BooleanStringExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forCharacters(DeclarationAnnotationAdapter annotationAdapter) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, CharacterStringExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forCharacters(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, CharacterStringExpressionConverter.instance());
    }

    public static ConversionDeclarationAnnotationElementAdapter<String> forCharacters(DeclarationAnnotationAdapter annotationAdapter, String elementName, boolean removeAnnotationWhenEmpty) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, removeAnnotationWhenEmpty, CharacterStringExpressionConverter.instance());
    }
}

