/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.ModifiedDeclaration;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberAnnotationElementAdapter<T>
implements AnnotationElementAdapter<T> {
    private final Member member;
    private final DeclarationAnnotationElementAdapter<T> daea;

    public MemberAnnotationElementAdapter(Member member, DeclarationAnnotationElementAdapter<T> daea) {
        this.member = member;
        this.daea = daea;
    }

    @Override
    public T getValue() {
        return this.daea.getValue(this.member.modifiedDeclaration());
    }

    @Override
    public T getValue(CompilationUnit astRoot) {
        return this.daea.getValue(this.member.modifiedDeclaration(astRoot));
    }

    @Override
    public void setValue(T value) {
        this.edit(this.buildSetValueEditor(value));
    }

    @Override
    public Expression expression() {
        return this.daea.expression(this.member.modifiedDeclaration());
    }

    @Override
    public Expression expression(CompilationUnit astRoot) {
        return this.daea.expression(this.member.modifiedDeclaration(astRoot));
    }

    @Override
    public ASTNode astNode() {
        return this.daea.astNode(this.member.modifiedDeclaration());
    }

    @Override
    public ASTNode astNode(CompilationUnit astRoot) {
        return this.daea.astNode(this.member.modifiedDeclaration(astRoot));
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.daea);
    }

    protected void edit(Member.Editor editor) {
        this.member.edit(editor);
    }

    protected Member.Editor buildSetValueEditor(T value) {
        return new SetValueEditor<T>(value, this.daea);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SetValueEditor<T>
    implements Member.Editor {
        private final DeclarationAnnotationElementAdapter<T> daea;
        private final T value;

        SetValueEditor(T value, DeclarationAnnotationElementAdapter<T> daea) {
            this.value = value;
            this.daea = daea;
        }

        @Override
        public void edit(ModifiedDeclaration declaration) {
            this.daea.setValue(this.value, declaration);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

