/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.mappings.IAssociationOverride;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JoinColumnContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationOverrideContext
extends BaseContext {
    IAssociationOverride associationOverride;
    private Collection<JoinColumnContext> joinColumnContexts;

    public AssociationOverrideContext(IContext parentContext, IAssociationOverride associationOverride) {
        super(parentContext);
        this.associationOverride = associationOverride;
        this.joinColumnContexts = this.buildJoinColumnContexts();
    }

    @Override
    protected void initialize() {
    }

    protected Collection<JoinColumnContext> buildJoinColumnContexts() {
        ArrayList<JoinColumnContext> contexts = new ArrayList<JoinColumnContext>();
        for (IJoinColumn joinColumn : this.associationOverride.getJoinColumns()) {
            contexts.add(new JoinColumnContext((IContext)this, joinColumn));
        }
        return contexts;
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext, IProgressMonitor monitor) {
        for (JoinColumnContext context : this.joinColumnContexts) {
            context.refreshDefaults(defaultsContext, monitor);
        }
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addJoinColumnMessages(messages);
    }

    protected void addJoinColumnMessages(List<IMessage> messages) {
        ITypeMapping typeMapping = this.associationOverride.typeMapping();
        for (IJoinColumn joinColumn : this.associationOverride.getJoinColumns()) {
            String table = joinColumn.getTable();
            boolean doContinue = joinColumn.isConnected();
            if (doContinue && typeMapping.tableNameIsInvalid(table)) {
                if (this.associationOverride.isVirtual()) {
                    messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{this.associationOverride.getName(), table, joinColumn.getName()}, joinColumn, joinColumn.tableTextRange()));
                } else {
                    messages.add(JpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{table, joinColumn.getName()}, joinColumn, joinColumn.tableTextRange()));
                }
                doContinue = false;
            }
            if (doContinue && !joinColumn.isResolved()) {
                if (this.associationOverride.isVirtual()) {
                    messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_NAME", new String[]{this.associationOverride.getName(), joinColumn.getName()}, joinColumn, joinColumn.nameTextRange()));
                } else {
                    messages.add(JpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getName()}, joinColumn, joinColumn.nameTextRange()));
                }
            }
            if (!doContinue || joinColumn.isReferencedColumnResolved()) continue;
            if (this.associationOverride.isVirtual()) {
                messages.add(JpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{this.associationOverride.getName(), joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.referencedColumnNameTextRange()));
                continue;
            }
            messages.add(JpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.referencedColumnNameTextRange()));
        }
    }
}

