/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jst.server.core.internal.GenericRuntime;
import org.eclipse.jst.server.core.internal.IGenericRuntimeWorkingCopy;
import org.eclipse.jst.server.ui.internal.ImageResource;
import org.eclipse.jst.server.ui.internal.Messages;
import org.eclipse.jst.server.ui.internal.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class GenericRuntimeComposite
extends Composite {
    protected static final String INSTALLED_JRE_PREFERENCE_PAGE_ID = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
    protected IRuntimeWorkingCopy runtimeWC;
    protected IGenericRuntimeWorkingCopy runtime;
    protected IWizardHandle wizard;
    protected Text name;
    protected Text installDir;
    protected Combo combo;
    protected List installedJREs;
    protected String[] jreNames;
    static /* synthetic */ Class class$0;

    protected GenericRuntimeComposite(Composite parent, IWizardHandle wizard) {
        super(parent, 0);
        this.wizard = wizard;
        wizard.setTitle(Messages.runtimeTypeTitle);
        wizard.setDescription(Messages.runtimeTypeDescription);
        wizard.setImageDescriptor(ImageResource.getImageDescriptor("wiz_runtimeType"));
        this.createControl();
    }

    protected void setRuntime(IRuntimeWorkingCopy newRuntime) {
        if (newRuntime == null) {
            this.runtimeWC = null;
            this.runtime = null;
        } else {
            this.runtimeWC = newRuntime;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.server.core.internal.IGenericRuntimeWorkingCopy");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.runtime = (IGenericRuntimeWorkingCopy)newRuntime.loadAdapter((Class)clazz, null);
        }
        this.init();
        this.validate();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "org.eclipse.jst.server.ui.jvrt0000");
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.runtimeTypeName);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.name = new Text((Composite)this, 2048);
        data = new GridData(768);
        this.name.setLayoutData((Object)data);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenericRuntimeComposite.this.runtimeWC.setName(GenericRuntimeComposite.this.name.getText());
                GenericRuntimeComposite.this.validate();
            }
        });
        label = new Label((Composite)this, 0);
        label.setText(Messages.runtimeTypeLocation);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.installDir = new Text((Composite)this, 2048);
        data = new GridData(768);
        this.installDir.setLayoutData((Object)data);
        this.installDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenericRuntimeComposite.this.runtimeWC.setLocation((IPath)new Path(GenericRuntimeComposite.this.installDir.getText()));
                GenericRuntimeComposite.this.validate();
            }
        });
        Button browse = SWTUtil.createButton(this, Messages.browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(GenericRuntimeComposite.this.getShell());
                dialog.setMessage(Messages.runtimeTypeSelectLocation);
                dialog.setFilterPath(GenericRuntimeComposite.this.installDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    GenericRuntimeComposite.this.installDir.setText(selectedDirectory);
                }
            }
        });
        this.updateJREs();
        label = new Label((Composite)this, 0);
        label.setText(Messages.runtimeTypeJRE);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.combo = new Combo((Composite)this, 12);
        this.combo.setItems(this.jreNames);
        data = new GridData(256);
        this.combo.setLayoutData((Object)data);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int sel = GenericRuntimeComposite.this.combo.getSelectionIndex();
                IVMInstall vmInstall = null;
                if (sel > 0) {
                    vmInstall = (IVMInstall)GenericRuntimeComposite.this.installedJREs.get(sel - 1);
                }
                GenericRuntimeComposite.this.runtime.setVMInstall(vmInstall);
                GenericRuntimeComposite.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button button = SWTUtil.createButton(this, Messages.runtimeTypeInstalledJREs);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentVM = GenericRuntimeComposite.this.combo.getText();
                if (GenericRuntimeComposite.this.showPreferencePage()) {
                    GenericRuntimeComposite.this.updateJREs();
                    GenericRuntimeComposite.this.combo.setItems(GenericRuntimeComposite.this.jreNames);
                    GenericRuntimeComposite.this.combo.setText(currentVM);
                    if (GenericRuntimeComposite.this.combo.getSelectionIndex() == -1) {
                        GenericRuntimeComposite.this.combo.select(0);
                    }
                }
            }
        });
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.name.forceFocus();
    }

    protected void updateJREs() {
        this.installedJREs = new ArrayList();
        IVMInstallType[] vmInstallTypes = JavaRuntime.getVMInstallTypes();
        int size = vmInstallTypes.length;
        int i = 0;
        while (i < size) {
            IVMInstall[] vmInstalls = vmInstallTypes[i].getVMInstalls();
            int size2 = vmInstalls.length;
            int j = 0;
            while (j < size2) {
                this.installedJREs.add(vmInstalls[j]);
                ++j;
            }
            ++i;
        }
        size = this.installedJREs.size();
        this.jreNames = new String[size + 1];
        this.jreNames[0] = Messages.runtimeTypeDefaultJRE;
        i = 0;
        while (i < size) {
            IVMInstall vmInstall = (IVMInstall)this.installedJREs.get(i);
            this.jreNames[i + 1] = vmInstall.getName();
            ++i;
        }
    }

    protected boolean showPreferencePage() {
        String id = INSTALLED_JRE_PREFERENCE_PAGE_ID;
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode node = manager.find("org.eclipse.jdt.ui.preferences.JavaBasePreferencePage").findSubNode(id);
        PreferenceManager manager2 = new PreferenceManager();
        manager2.addToRoot(node);
        PreferenceDialog dialog = new PreferenceDialog(this.getShell(), manager2);
        dialog.create();
        return dialog.open() == 0;
    }

    protected void init() {
        if (this.installDir == null || this.runtime == null) {
            return;
        }
        this.name.setText(this.runtimeWC.getName());
        if (this.runtimeWC.getLocation() != null) {
            this.installDir.setText(this.runtimeWC.getLocation().toOSString());
        } else {
            this.installDir.setText("");
        }
        if (((GenericRuntime)this.runtime).isUsingDefaultJRE()) {
            this.combo.select(0);
        } else {
            boolean found = false;
            int size = this.installedJREs.size();
            int i = 0;
            while (i < size) {
                IVMInstall vmInstall = (IVMInstall)this.installedJREs.get(i);
                if (vmInstall.equals(this.runtime.getVMInstall())) {
                    this.combo.select(i + 1);
                    found = true;
                }
                ++i;
            }
            if (!found) {
                this.combo.select(0);
            }
        }
    }

    protected void validate() {
        if (this.runtime == null) {
            this.wizard.setMessage("", 3);
            return;
        }
        IStatus status = this.runtimeWC.validate(null);
        if (status == null || status.isOK()) {
            this.wizard.setMessage(null, 0);
        } else {
            this.wizard.setMessage(status.getMessage(), 3);
        }
    }
}

