/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal.facets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.facets.RuntimeComponentProviderWrapper;
import org.eclipse.wst.server.core.internal.facets.RuntimeFacetMapping;

public class FacetMappingUtil
extends Plugin {
    private static List runtimeComponentProviders;
    private static List runtimeFacetMappings;

    public static RuntimeFacetMapping[] getRuntimeFacetMapping() {
        if (runtimeFacetMappings == null) {
            FacetMappingUtil.loadRuntimeFacetMapping();
        }
        RuntimeFacetMapping[] rfm = new RuntimeFacetMapping[runtimeFacetMappings.size()];
        runtimeFacetMappings.toArray(rfm);
        return rfm;
    }

    public static void addFacetRuntimeComponents(IRuntime runtime, List components) {
        if (runtime == null || runtime.getRuntimeType() == null) {
            throw new IllegalArgumentException();
        }
        if (runtimeComponentProviders == null) {
            FacetMappingUtil.loadRuntimeComponentProviders();
        }
        Iterator iterator = runtimeComponentProviders.iterator();
        while (iterator.hasNext()) {
            List list;
            RuntimeComponentProviderWrapper runtimeComponentProvider = (RuntimeComponentProviderWrapper)iterator.next();
            if (!runtimeComponentProvider.supportsRuntimeType(runtime.getRuntimeType()) || (list = runtimeComponentProvider.getComponents(runtime)) == null) continue;
            components.addAll(list);
        }
    }

    private static synchronized void loadRuntimeComponentProviders() {
        if (runtimeComponentProviders != null) {
            return;
        }
        Trace.trace(0, "->- Loading .runtimeFacetComponentProviders extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.core", "runtimeFacetComponentProviders");
        int size = cf.length;
        ArrayList<RuntimeComponentProviderWrapper> list = new ArrayList<RuntimeComponentProviderWrapper>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new RuntimeComponentProviderWrapper(cf[i]));
                Trace.trace(0, "  Loaded runtimeFacetComponentProvider: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(3, "  Could not load runtimeFacetComponentProvider: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        cf = registry.getConfigurationElementsFor("org.eclipse.jst.server.core.internalRuntimeComponentProviders");
        size = cf.length;
        i = 0;
        while (i < size) {
            try {
                list.add(new RuntimeComponentProviderWrapper(cf[i]));
                Trace.trace(0, "  Loaded runtimeFacetComponentProvider: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(3, "  Could not load runtimeFacetComponentProvider: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        runtimeComponentProviders = list;
        Trace.trace(0, "-<- Done loading .runtimeFacetComponentProviders extension point -<-");
    }

    private static synchronized void loadRuntimeFacetMapping() {
        if (runtimeFacetMappings != null) {
            return;
        }
        Trace.trace(0, "->- Loading .runtimeFacetMapping extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.jst.server.core.runtimeFacetMappings");
        int size = cf.length;
        ArrayList<RuntimeFacetMapping> list = new ArrayList<RuntimeFacetMapping>(size);
        int i = 0;
        while (i < size) {
            try {
                list.add(new RuntimeFacetMapping(cf[i]));
                Trace.trace(0, "  Loaded runtimeFacetMapping: " + cf[i].getAttribute("runtimeTypeId"));
            }
            catch (Throwable t) {
                Trace.trace(3, "  Could not load runtimeFacetMapping: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        runtimeFacetMappings = list;
        Trace.trace(0, "-<- Done loading .runtimeFacetMapping extension point -<-");
    }
}

