/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldChangeListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IStringButtonAdapter;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ISupportTextValue;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DialogFieldWrapper
implements DialogField,
ISupportTextValue {
    private DialogField _wrappedDialogField;
    private Button _button;
    private boolean _buttonEnabled;
    private Image _buttonImage;
    private Image _disabledImage;
    private String _buttonLabel;
    private IStringButtonAdapter _adapter;

    public DialogFieldWrapper(DialogField field, Image image, Image disabledImage) {
        if (!(field instanceof ISupportTextValue)) {
            throw new IllegalArgumentException("Field must be ISupportTextValue");
        }
        this._wrappedDialogField = field;
        this._buttonImage = image;
        this._disabledImage = disabledImage;
    }

    public DialogFieldWrapper(DialogField field, String label) {
        if (!(field instanceof ISupportTextValue)) {
            throw new IllegalArgumentException("Field must be ISupportTextValue");
        }
        this._wrappedDialogField = field;
        this._buttonLabel = label;
    }

    public void setButtonAdapter(IStringButtonAdapter adapter) {
        this._adapter = adapter;
        this.updateButtonControl();
    }

    public void setTextWithoutUpdate(String value) {
        ((ISupportTextValue)((Object)this._wrappedDialogField)).setTextWithoutUpdate(value);
    }

    public String getText() {
        return ((ISupportTextValue)((Object)this._wrappedDialogField)).getText();
    }

    public void setText(String value) {
        ((ISupportTextValue)((Object)this._wrappedDialogField)).setText(value);
    }

    public Control[] doFillIntoGrid(FormToolkit toolkit, Composite parent, int nColumns) {
        Control[] wrappedControls = this._wrappedDialogField.doFillIntoGrid(toolkit, parent, nColumns - 1);
        Control[] result = new Control[wrappedControls.length];
        Control button = this.getButton(toolkit, parent);
        button.setLayoutData((Object)this.gridDataForButton(1));
        System.arraycopy(wrappedControls, 0, result, 0, wrappedControls.length);
        result[result.length - 1] = this._button;
        return result;
    }

    private GridData gridDataForButton(int span) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        gd.heightHint = 18;
        gd.widthHint = 18;
        return gd;
    }

    private Control getButton(FormToolkit toolkit, Composite parent) {
        if (this._button == null) {
            Assert.isNotNull((Object)parent, (String)"uncreated control requested with composite null");
            if (toolkit != null) {
                this._button = toolkit.createButton(parent, "", 8);
                if (this._buttonImage != null) {
                    this._button.setImage(this._buttonImage);
                } else {
                    this._button.setText(this._buttonLabel);
                }
            } else {
                this._button = new Button(parent, 8);
                if (this._buttonImage != null) {
                    this._button.setImage(this._buttonImage);
                } else {
                    this._button.setText(this._buttonLabel);
                }
            }
            this._button.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (!DialogFieldWrapper.this._button.isEnabled() && DialogFieldWrapper.this._disabledImage != null) {
                        Rectangle buttonBounds = DialogFieldWrapper.this._button.getBounds();
                        Rectangle imageBounds = DialogFieldWrapper.this._disabledImage.getBounds();
                        e.gc.drawImage(DialogFieldWrapper.this._disabledImage, (buttonBounds.width - imageBounds.width) / 2, (buttonBounds.height - imageBounds.height) / 2);
                    }
                }
            });
            this._button.setEnabled(this.isEnabled() && this._buttonEnabled);
            this._button.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    DialogFieldWrapper.this.buttonPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    DialogFieldWrapper.this.buttonPressed();
                }
            });
        }
        return this._button;
    }

    public Control getLabelControl(FormToolkit _formToolkit, Composite parent) {
        return this._wrappedDialogField.getLabelControl(_formToolkit, parent);
    }

    public void setHyperLink(IHyperlinkListener listener) {
        this._wrappedDialogField.setHyperLink(listener);
    }

    public void setLabelText(String labeltext) {
        this._wrappedDialogField.setLabelText(labeltext);
    }

    public void setDialogFieldChangeListener(IDialogFieldChangeListener listener) {
        this._wrappedDialogField.setDialogFieldChangeListener(listener);
    }

    public void setDialogFieldApplyListener(IDialogFieldApplyListener listener) {
        this._wrappedDialogField.setDialogFieldApplyListener(listener);
    }

    public boolean setFocus() {
        return this._wrappedDialogField.setFocus();
    }

    public int getNumberOfControls() {
        return this._wrappedDialogField.getNumberOfControls() + 1;
    }

    public void setButtonEnabled(boolean enabled) {
        this._buttonEnabled = enabled;
        this.updateButtonControl();
    }

    public boolean isButtonEnabled() {
        return this._buttonEnabled;
    }

    public void setEnabled(boolean enabled) {
        this._wrappedDialogField.setEnabled(enabled);
        this.updateButtonControl();
    }

    private void updateButtonControl() {
        if (this._button != null) {
            this._button.setEnabled(this.isEnabled() && this._buttonEnabled && this._adapter != null);
            this._button.redraw();
        }
    }

    public boolean isEnabled() {
        return this._wrappedDialogField.isEnabled();
    }

    public Object getAttachedData(Object key) {
        return this._wrappedDialogField.getAttachedData(key);
    }

    public void putAttachedData(Object key, Object value) {
        this._wrappedDialogField.putAttachedData(key, value);
    }

    protected void buttonPressed() {
        if (this._adapter != null) {
            this._adapter.changeControlPressed(this);
        }
    }

    public void handleGrabHorizontal() {
        this._wrappedDialogField.handleGrabHorizontal();
    }

    public DialogField getWrappedDialogField() {
        return this._wrappedDialogField;
    }

    public boolean isRequired() {
        return this._wrappedDialogField.isRequired();
    }

    public void setToolTip(String toolTip) {
        this._wrappedDialogField.setToolTip(toolTip);
    }
}

