/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.outline;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.eclipse.wst.xsd.ui.internal.adt.design.DesignViewContextMenuProvider;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.IModelProxy;
import org.eclipse.wst.xsd.ui.internal.adt.editor.ADTMultiPageEditor;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IModel;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;

public class ADTContentOutlinePage
extends ContentOutlinePage {
    protected ADTMultiPageEditor editor;
    protected int level = 0;
    protected Object model;
    protected ITreeContentProvider contentProvider;
    protected ILabelProvider labelProvider;
    protected MultiPageSelectionProvider selectionManager;
    protected SelectionManagerSelectionChangeListener selectionManagerSelectionChangeListener = new SelectionManagerSelectionChangeListener();

    public ADTContentOutlinePage(ADTMultiPageEditor editor) {
        this.editor = editor;
    }

    public void setModel(Object newModel) {
        this.model = newModel;
    }

    public void setContentProvider(ITreeContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().setContentProvider((IContentProvider)this.contentProvider);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.getTreeViewer().setInput(this.model);
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        MenuManager menuManager = new MenuManager("#popup");
        menuManager.setRemoveAllWhenShown(true);
        Menu menu = menuManager.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
        this.setSelectionManager(this.editor.getSelectionManager());
        DesignViewContextMenuProvider menuProvider = new DesignViewContextMenuProvider((IEditorPart)this.editor, null, this.editor.getSelectionManager());
        menuManager.addMenuListener((IMenuListener)menuProvider);
        this.getSite().registerContextMenu("org.eclipse.wst.xsd.ui.popup.outline", menuManager, (ISelectionProvider)this.editor.getSelectionManager());
        this.getTreeViewer().getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                StructuredSelection selection;
                Object obj;
                ISelection iSelection = ADTContentOutlinePage.this.getTreeViewer().getSelection();
                if (iSelection instanceof StructuredSelection && (obj = (selection = (StructuredSelection)iSelection).getFirstElement()) instanceof XSDConcreteComponent) {
                    XSDConcreteComponent comp = (XSDConcreteComponent)obj;
                    boolean cfr_ignored_0 = comp.getContainer() instanceof XSDSchema;
                }
            }
        });
    }

    public void dispose() {
        this.contentProvider.dispose();
        super.dispose();
    }

    public void setExpandToLevel(int i) {
        this.level = i;
    }

    public void setInput(Object value) {
        this.getTreeViewer().setInput(value);
        this.getTreeViewer().expandToLevel(this.level);
    }

    public void setSelectionManager(MultiPageSelectionProvider newSelectionManager) {
        if (this.selectionManager != null) {
            this.selectionManager.removeSelectionChangedListener((ISelectionChangedListener)this.selectionManagerSelectionChangeListener);
        }
        this.selectionManager = newSelectionManager;
        if (this.selectionManager != null) {
            this.selectionManager.addSelectionChangedListener((ISelectionChangedListener)this.selectionManagerSelectionChangeListener);
        }
    }

    void updateStatusLine(IStatusLineManager mgr, ISelection selection) {
        String text = null;
        Image image = null;
        StatusLineLabelProvider statusLineLabelProvider = new StatusLineLabelProvider(this.getTreeViewer());
        if (statusLineLabelProvider != null && selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            text = statusLineLabelProvider.getText(firstElement);
            image = statusLineLabelProvider.getImage(firstElement);
        }
        if (image == null) {
            mgr.setMessage(text);
        } else {
            mgr.setMessage(image, text);
        }
    }

    class SelectionManagerSelectionChangeListener
    implements ISelectionChangedListener {
        SelectionManagerSelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ADTContentOutlinePage.this.updateStatusLine(ADTContentOutlinePage.this.getSite().getActionBars().getStatusLineManager(), event.getSelection());
            if (event.getSelectionProvider() != ADTContentOutlinePage.this) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                StructuredSelection currentSelection = (StructuredSelection)ADTContentOutlinePage.this.getTreeViewer().getSelection();
                if (selection.getFirstElement() instanceof IModel) {
                    if (!(currentSelection.getFirstElement() instanceof IModelProxy)) {
                        ADTContentOutlinePage.this.getTreeViewer().setSelection(event.getSelection(), true);
                    }
                } else {
                    ADTContentOutlinePage.this.getTreeViewer().setSelection(event.getSelection(), true);
                }
            }
        }
    }

    private class StatusLineLabelProvider
    extends JFaceNodeLabelProvider {
        TreeViewer treeViewer = null;

        public StatusLineLabelProvider(TreeViewer viewer) {
            this.treeViewer = viewer;
        }

        public String getText(Object element) {
            if (element == null) {
                return null;
            }
            StringBuffer s = new StringBuffer();
            s.append(ADTContentOutlinePage.this.labelProvider.getText(element));
            return s.toString();
        }

        public Image getImage(Object element) {
            return ADTContentOutlinePage.this.labelProvider.getImage(element);
        }
    }

    class XSDKeyListener
    extends KeyAdapter {
        XSDKeyListener() {
        }
    }
}

