/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.classpathdep;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.classpathdep.UpdateClasspathAttributeUtil;
import org.eclipse.jst.j2ee.internal.classpathdep.UpdateClasspathAttributesDataModelProperties;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class UpdateClasspathAttributesOperation
extends AbstractDataModelOperation
implements UpdateClasspathAttributesDataModelProperties {
    public UpdateClasspathAttributesOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IProject project = ProjectUtilities.getProject((String)this.model.getStringProperty("UpdateClasspathAttributesDataModel.PROJECT_NAME"));
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                this.validateEdit(project);
                Map entriesToAdd = (Map)this.model.getProperty("UpdateClasspathAttributesDataModel.ENTRIES_TO_ADD_ATTRIBUTE");
                if (entriesToAdd == null) {
                    Map entriesToRemove = (Map)this.model.getProperty("UpdateClasspathAttributesDataModel.ENTRIES_TO_REMOVE_ATTRIBUTE");
                    if (entriesToRemove == null) {
                        Map entriesToRuntimePath = (Map)this.model.getProperty("UpdateClasspathAttributesDataModel.ENTRIES_WITH_ATTRIBUTE");
                        HashMap<IClasspathEntry, IClasspathAttribute> entriesToAttrib = new HashMap<IClasspathEntry, IClasspathAttribute>();
                        for (IClasspathEntry entry : entriesToRuntimePath.keySet()) {
                            IPath runtimePath = (IPath)entriesToRuntimePath.get(entry);
                            IClasspathAttribute attrib = ClasspathDependencyUtil.checkForComponentDependencyAttribute(entry);
                            if (attrib == null) {
                                attrib = UpdateClasspathAttributeUtil.createDependencyAttribute(runtimePath);
                            }
                            entriesToAttrib.put(entry, attrib);
                        }
                        this.updateDependencyAttributes(javaProject, entriesToAttrib);
                    } else {
                        this.removeDependencyAttributes(javaProject, entriesToRemove);
                    }
                } else {
                    this.addDependencyAttributes(javaProject, entriesToAdd);
                }
            }
        }
        catch (CoreException ce) {
            Logger.getLogger((String)"org.eclipse.jst.j2ee").logError((Throwable)ce);
            return new Status(4, "org.eclipse.jst.j2ee", 0, ce.getLocalizedMessage(), (Throwable)ce);
        }
        return Status.OK_STATUS;
    }

    protected void validateEdit(IProject project) throws CoreException {
        List affectedFiles = ProjectUtilities.getFilesAffectedByClasspathChange((IProject)project);
        IFile[] files = affectedFiles.toArray(new IFile[affectedFiles.size()]);
        IStatus result = J2EEPlugin.getWorkspace().validateEdit(files, null);
        if (!result.isOK()) {
            throw new CoreException(result);
        }
    }

    private void addDependencyAttributes(IJavaProject javaProject, Map entries) throws CoreException {
        this.alterDependencyAttributes(javaProject, entries, true);
    }

    private void removeDependencyAttributes(IJavaProject javaProject, Map entries) throws CoreException {
        this.alterDependencyAttributes(javaProject, entries, false);
    }

    private void alterDependencyAttributes(IJavaProject javaProject, Map entries, boolean add) throws CoreException {
        Map entriesWithAttrib = ClasspathDependencyUtil.getRawComponentClasspathDependencies(javaProject);
        for (IClasspathEntry entry : entries.keySet()) {
            if (add) {
                if (this.getMatchingEntryIgnoreAttributes(entriesWithAttrib, entry) != null) continue;
                IPath runtimePath = (IPath)entries.get(entry);
                if (runtimePath == null) {
                    boolean isWebApp = J2EEProjectUtilities.isDynamicWebProject(javaProject.getProject());
                    runtimePath = ClasspathDependencyUtil.getDefaultRuntimePath(isWebApp);
                }
                IClasspathAttribute attrib = UpdateClasspathAttributeUtil.createDependencyAttribute(runtimePath);
                entriesWithAttrib.put(entry, attrib);
                continue;
            }
            IClasspathEntry matching = this.getMatchingEntryIgnoreAttributes(entriesWithAttrib, entry);
            if (matching == null) continue;
            entriesWithAttrib.remove(matching);
        }
        this.updateDependencyAttributes(javaProject, entriesWithAttrib);
    }

    private IClasspathEntry getMatchingEntryIgnoreAttributes(Map entries, IClasspathEntry entry) {
        for (IClasspathEntry e : entries.keySet()) {
            if (e.getEntryKind() != entry.getEntryKind() || !e.getPath().equals((Object)entry.getPath()) || e.isExported() != entry.isExported()) continue;
            return e;
        }
        return null;
    }

    private void updateDependencyAttributes(IJavaProject javaProject, Map entriesWithAttrib) throws CoreException {
        if (javaProject == null || !javaProject.getProject().isAccessible()) {
            return;
        }
        ArrayList<IClasspathEntry> updatedClasspath = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
        boolean needToUpdateClasspath = false;
        IClasspathAttribute attrib = UpdateClasspathAttributeUtil.createDependencyAttribute();
        int i = 0;
        while (i < rawClasspath.length) {
            IClasspathEntry entry = rawClasspath[i];
            int kind = entry.getEntryKind();
            boolean hasAttribute = ClasspathDependencyUtil.checkForComponentDependencyAttribute(entry) != null;
            boolean shouldHaveAttribute = entriesWithAttrib.containsKey(entry);
            boolean updateAttributes = false;
            IClasspathAttribute[] updatedAttributes = null;
            if (shouldHaveAttribute) {
                if (!hasAttribute) {
                    attrib = (IClasspathAttribute)entriesWithAttrib.get(entry);
                    updatedAttributes = this.updateAttributes(entry.getExtraAttributes(), attrib, true);
                    needToUpdateClasspath = true;
                    updateAttributes = true;
                }
            } else if (hasAttribute) {
                updatedAttributes = this.updateAttributes(entry.getExtraAttributes(), attrib, false);
                needToUpdateClasspath = true;
                updateAttributes = true;
            }
            if (updateAttributes) {
                switch (kind) {
                    case 5: {
                        entry = JavaCore.newContainerEntry((IPath)entry.getPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])updatedAttributes, (boolean)entry.isExported());
                        break;
                    }
                    case 1: {
                        entry = JavaCore.newLibraryEntry((IPath)entry.getPath(), (IPath)entry.getSourceAttachmentPath(), (IPath)entry.getSourceAttachmentRootPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])updatedAttributes, (boolean)entry.isExported());
                        break;
                    }
                    case 4: {
                        entry = JavaCore.newVariableEntry((IPath)entry.getPath(), (IPath)entry.getSourceAttachmentPath(), (IPath)entry.getSourceAttachmentRootPath(), (IAccessRule[])entry.getAccessRules(), (IClasspathAttribute[])updatedAttributes, (boolean)entry.isExported());
                        break;
                    }
                    case 2: {
                        entry = JavaCore.newProjectEntry((IPath)entry.getPath(), (IAccessRule[])entry.getAccessRules(), (boolean)entry.combineAccessRules(), (IClasspathAttribute[])updatedAttributes, (boolean)entry.isExported());
                        break;
                    }
                    case 3: {
                        entry = JavaCore.newSourceEntry((IPath)entry.getPath(), (IPath[])entry.getInclusionPatterns(), (IPath[])entry.getExclusionPatterns(), (IPath)entry.getOutputLocation(), (IClasspathAttribute[])updatedAttributes);
                    }
                }
            }
            updatedClasspath.add(entry);
            ++i;
        }
        if (needToUpdateClasspath) {
            IClasspathEntry[] updatedCPArray = updatedClasspath.toArray(new IClasspathEntry[updatedClasspath.size()]);
            javaProject.setRawClasspath(updatedCPArray, null);
        }
    }

    private IClasspathAttribute[] updateAttributes(IClasspathAttribute[] currentAttribs, IClasspathAttribute targetAttrib, boolean add) {
        ArrayList<IClasspathAttribute> updatedAttribs = new ArrayList<IClasspathAttribute>();
        boolean hasAttrib = false;
        int i = 0;
        while (i < currentAttribs.length) {
            block6: {
                block5: {
                    if (!currentAttribs[i].getName().equals(targetAttrib.getName())) break block5;
                    hasAttrib = true;
                    if (!add) break block6;
                }
                updatedAttribs.add(currentAttribs[i]);
            }
            ++i;
        }
        if (add && !hasAttrib) {
            updatedAttribs.add(targetAttrib);
        }
        return updatedAttribs.toArray(new IClasspathAttribute[updatedAttribs.size()]);
    }
}

