/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.range;

import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class DesignerToolBarAction
extends Action
implements IUpdate,
ISelectionChangedListener {
    private IHTMLGraphicalViewer _viewer;

    public DesignerToolBarAction(String text, int style) {
        super(text, style);
    }

    public DesignerToolBarAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.update();
    }

    public void update() {
        if (this.canRun(this._viewer)) {
            this.setEnabled(true);
            this.updateStatus();
        } else {
            this.setEnabled(false);
        }
    }

    public void updateStatus() {
        DesignRange range = this._viewer.getRangeSelection();
        DOMRange domRange = null;
        if (range != null) {
            domRange = new DOMRange(DOMPositionHelper.toDOMPosition(range.getStartPosition()), DOMPositionHelper.toDOMPosition(range.getEndPosition()));
            if (this.isApplied(domRange)) {
                this.setChecked(true);
            } else {
                this.setChecked(false);
            }
        }
    }

    protected abstract boolean isApplied(DOMRange var1);

    protected boolean canRun(IHTMLGraphicalViewer viewer) {
        DesignRange range;
        return viewer != null && viewer.isInRangeMode() && viewer.getModel().getDocument().hasChildNodes() && (range = viewer.getRangeSelection()) != null && range.isValid();
    }

    public void setViewer(IHTMLGraphicalViewer viewer) {
        if (viewer == this._viewer) {
            return;
        }
        if (this._viewer != null) {
            this._viewer.removeSelectionChangedListener(this);
        }
        this._viewer = viewer;
        if (this._viewer != null) {
            this._viewer.addSelectionChangedListener(this);
        }
        this.update();
    }

    public void run() {
        DesignRange range = this._viewer.getRangeSelection();
        if (range == null || !range.isValid()) {
            return;
        }
        Command command = this.getCommand();
        if (command != null) {
            command.execute();
        }
    }

    protected abstract Command getCommand();

    public IHTMLGraphicalViewer getViewer() {
        return this._viewer;
    }
}

