/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.range;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.actions.link.MakeLinkAction;
import org.eclipse.jst.pagedesigner.actions.range.AlignSupport;
import org.eclipse.jst.pagedesigner.actions.range.DesignerToolBarAction;
import org.eclipse.jst.pagedesigner.actions.range.ParagraphSupport;
import org.eclipse.jst.pagedesigner.editors.actions.DesignActionBarFactory;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Element;

public class RangeActionGroup
extends ActionGroup {
    private static final Action action = new Action(){};

    public void fillContextMenu(IMenuManager contextMenu) {
        DesignRange selection = this.fixUpSelection(this.getContext().getSelection());
        if (selection == null) {
            return;
        }
        IContributionItem styleSubMenuItem = contextMenu.find("org.eclipse.jst.pagedesigner.context.submenu.style");
        if (styleSubMenuItem instanceof IMenuManager) {
            IMenuManager subMenu = (IMenuManager)styleSubMenuItem;
            if (this.getContext().getInput() instanceof IHTMLGraphicalViewer) {
                this.addParagraphFormatMenu(subMenu, selection, (IHTMLGraphicalViewer)this.getContext().getInput());
                this.addHorizontalAlignMenu(subMenu, selection, (IHTMLGraphicalViewer)this.getContext().getInput());
                this.addTextStyleMenu(subMenu, (IHTMLGraphicalViewer)this.getContext().getInput());
            }
            this.addLinkMenu(subMenu, selection);
        }
    }

    private DesignRange fixUpSelection(ISelection selection) {
        if (selection instanceof DesignRange) {
            return (DesignRange)selection;
        }
        return null;
    }

    private void addLinkMenu(IMenuManager menu, DesignRange selection) {
        MakeLinkAction action1 = new MakeLinkAction(selection);
        menu.appendToGroup("org.eclipse.jst.pagedesigner.style", (IAction)action1);
    }

    private void addTextStyleMenu(IMenuManager menu, final IHTMLGraphicalViewer viewer) {
        MenuManager submenu = new MenuManager(PDPlugin.getResourceString("ActionGroup.Submenu.TextStyle"));
        submenu.add((IAction)action);
        submenu.setRemoveAllWhenShown(true);
        submenu.addMenuListener(new IMenuListener((IMenuManager)submenu){
            private final /* synthetic */ IMenuManager val$submenu;
            {
                this.val$submenu = iMenuManager;
            }

            public void menuAboutToShow(IMenuManager manager) {
                DesignerToolBarAction action1 = null;
                action1 = DesignActionBarFactory.getInstance().getStyleAction("u");
                action1.setViewer(viewer);
                this.val$submenu.add((IAction)action1);
                action1 = DesignActionBarFactory.getInstance().getStyleAction("b");
                action1.setViewer(viewer);
                this.val$submenu.add((IAction)action1);
                action1 = DesignActionBarFactory.getInstance().getStyleAction("i");
                action1.setViewer(viewer);
                this.val$submenu.add((IAction)action1);
                action1 = DesignActionBarFactory.getInstance().getStyleAction("small");
                action1.setViewer(viewer);
                this.val$submenu.add((IAction)action1);
                action1 = DesignActionBarFactory.getInstance().getStyleAction("big");
                action1.setViewer(viewer);
                this.val$submenu.add((IAction)action1);
            }
        });
        menu.appendToGroup("org.eclipse.jst.pagedesigner.style", (IContributionItem)submenu);
    }

    private void addHorizontalAlignMenu(IMenuManager menu, DesignRange selection, IHTMLGraphicalViewer viewer) {
        Element[] alignNodes = new Element[4];
        String[] alignValues = new String[]{"left", "center", "right", "justify"};
        IDOMDocument document = viewer.getModel().getDocument();
        int i = 0;
        while (i < 4) {
            Element node = document.createElement("p");
            node.setAttribute("align", alignValues[i]);
            alignNodes[i] = node;
            ++i;
        }
        AlignSupport.setAlignNodes(alignNodes);
        MenuManager submenu = new MenuManager(PDPlugin.getResourceString("ActionGroup.Submenu.Align"));
        submenu.add((IAction)action);
        submenu.setRemoveAllWhenShown(true);
        submenu.addMenuListener(new IMenuListener((IMenuManager)submenu, viewer){
            private final /* synthetic */ IMenuManager val$submenu;
            private final /* synthetic */ IHTMLGraphicalViewer val$viewer;
            {
                this.val$submenu = iMenuManager;
                this.val$viewer = iHTMLGraphicalViewer;
            }

            public void menuAboutToShow(IMenuManager manager) {
                AlignSupport.createAlignActions(this.val$submenu, this.val$viewer);
            }
        });
        menu.appendToGroup("org.eclipse.jst.pagedesigner.style", (IContributionItem)submenu);
    }

    private void addParagraphFormatMenu(IMenuManager menu, DesignRange selection, IHTMLGraphicalViewer viewer) {
        MenuManager submenu = new MenuManager(PDPlugin.getResourceString("ActionGroup.Submenu.ParagraphFormat"));
        submenu.add((IAction)action);
        int mode = ParagraphSupport.getCurrentParagraphMode(selection);
        submenu.addMenuListener(new IMenuListener((IMenuManager)submenu, selection, mode, viewer){
            private final /* synthetic */ IMenuManager val$submenu;
            private final /* synthetic */ DesignRange val$selection;
            private final /* synthetic */ int val$mode;
            private final /* synthetic */ IHTMLGraphicalViewer val$viewer;
            {
                this.val$submenu = iMenuManager;
                this.val$selection = designRange;
                this.val$mode = n;
                this.val$viewer = iHTMLGraphicalViewer;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.val$submenu.removeAll();
                ParagraphSupport.createParagraphActions(this.val$submenu, this.val$selection, this.val$mode, this.val$viewer);
            }
        });
        menu.appendToGroup("org.eclipse.jst.pagedesigner.style", (IContributionItem)submenu);
    }
}

