/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.range;

import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.w3c.dom.Node;

public class WorkNode {
    private WorkNode parent;
    private WorkNode previous;
    private WorkNode next;
    private Node node;
    private int[] pos;
    private boolean isRoot;

    public WorkNode(Node node, int pos1, int pos2) {
        this.pos = this.resoveOffsets(node, pos1, pos2);
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public int[] getQualifiedOffsets() {
        int[] result = new int[]{this.getPosOffsets()[0], this.getPosOffsets()[1]};
        int n = result[0] < 0 ? 0 : result[0];
        result[0] = n;
        int length = EditModelQuery.getNodeLenth(this.node);
        result[0] = result[0] > length ? length : result[0];
        result[1] = result[1] < 0 ? 0 : result[1];
        result[1] = result[1] > length ? length : result[1];
        return result;
    }

    public int[] getPosOffsets() {
        return this.pos;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public WorkNode getNext() {
        return this.next;
    }

    public void setNext(WorkNode next) {
        this.next = next;
    }

    public WorkNode getParent() {
        return this.parent;
    }

    public void setParent(WorkNode parent) {
        this.parent = parent;
    }

    public WorkNode getPrevious() {
        return this.previous;
    }

    public void setPrevious(WorkNode previous) {
        this.previous = previous;
    }

    private int[] resoveOffsets(Node node1, int pos1, int pos2) {
        int left = EditModelQuery.getNodeStartIndex(node1);
        return new int[]{pos1 - left, pos2 - left};
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Node:").append(this.node).append(" pos[]:").append(this.pos);
        return sb.toString();
    }

    public boolean isWholeSelected() {
        int start = EditModelQuery.getNodeStartIndex(this.node);
        int end = EditModelQuery.getNodeEndIndex(this.node);
        return this.getQualifiedOffsets()[0] <= 0 && this.getQualifiedOffsets()[1] >= end - start;
    }
}

