/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.BlockBox;
import org.eclipse.jst.pagedesigner.css2.layout.FlowBox;
import org.eclipse.jst.pagedesigner.css2.layout.FlowContext;
import org.eclipse.jst.pagedesigner.css2.layout.LineBox;
import org.eclipse.jst.pagedesigner.css2.value.Length;

public class BlockFlowContext
implements FlowContext {
    protected LineBox _currentLine;
    private LineBox _previousLine = null;
    protected BlockBox _blockBox;
    protected FlowContext _originalContext;
    protected ICSSStyle _style;

    public BlockFlowContext(FlowContext originalContext, ICSSStyle style) {
        this._originalContext = originalContext;
        this._style = style;
        this.setup();
    }

    public int getContainerWidth() {
        return this._originalContext.getContainerWidth();
    }

    public void setup() {
        this._blockBox = new BlockBox();
        this._blockBox.setRecommendedWidth(this.getRecommendedWidth());
        this._currentLine = this.getCurrentLine();
        this._previousLine = null;
    }

    private int getRecommendedWidth() {
        int containerWidth = this.getContainerWidth();
        Object leftObj = this._style.getStyleProperty("left");
        if (leftObj != null && leftObj instanceof Length) {
            Length left = (Length)leftObj;
            int intLeft = left.getValue();
            if (left.isPercentage()) {
                intLeft = containerWidth * intLeft / 100;
            }
            if (intLeft < containerWidth) {
                return containerWidth - intLeft;
            }
        }
        return containerWidth;
    }

    public void addToCurrentLine(FlowBox block) {
        this.getCurrentLine().add(block);
    }

    public void endLine() {
        LineBox box;
        if (this._currentLine == null) {
            return;
        }
        if (!this._currentLine.isOccupied()) {
            return;
        }
        this.layoutLine();
        this._previousLine = box = this._currentLine;
        this._currentLine = null;
    }

    public LineBox getCurrentLine() {
        if (this._currentLine == null) {
            this.createNewLine();
        }
        return this._currentLine;
    }

    public LineBox getCurrentLine(int topMargin) {
        if (this._currentLine == null) {
            this.createNewLine(topMargin);
        }
        return this._currentLine;
    }

    private void createNewLine(int topMargin) {
        this.createNewLine();
    }

    protected void createNewLine() {
        this._currentLine = new LineBox();
        this.setupLine(this._currentLine, Integer.MIN_VALUE);
    }

    protected void setupLine(LineBox line, int topMargin) {
        line.clear();
        line._x = this._blockBox._borderInsets.left + this._blockBox._paddingInsets.left;
        if (this._previousLine == null) {
            line._y = this._blockBox._borderInsets.top + this._blockBox._paddingInsets.top;
            if (topMargin != Integer.MIN_VALUE) {
                line._y += topMargin;
            }
        } else {
            line._y = topMargin == Integer.MIN_VALUE ? this._previousLine._y + this._previousLine.getHeight() + this.getLinePadding() + this._previousLine._marginInsets.bottom : this._previousLine._y + this._previousLine.getHeight() + Math.max(topMargin, this._previousLine._marginInsets.bottom);
        }
    }

    public int getCurrentY() {
        return this.getCurrentLine()._y;
    }

    public boolean isCurrentLineOccupied() {
        return this._currentLine != null && this._currentLine.isOccupied();
    }

    public int getLastMarginRight() {
        if (this._currentLine == null || !this._currentLine.isOccupied()) {
            return 0;
        }
        FlowBox box = (FlowBox)this._currentLine.getFragments().get(this._currentLine.getFragments().size() - 1);
        if (box != null) {
            return box._marginInsets.right;
        }
        return 0;
    }

    public boolean isCalculatingMaxWidth() {
        return false;
    }

    protected void layoutLine() {
        this._currentLine.commit();
        this._blockBox.add(this._currentLine);
    }

    public void endBlock() {
        this.endLine();
    }

    int getLinePadding() {
        return 0;
    }
}

