/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import java.text.BreakIterator;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jst.pagedesigner.css2.layout.TextFragmentBox;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;

public class FlowUtilities
extends FigureUtilities {
    public static int setupFragmentBasedOnTextSpace(TextFragmentBox frag, String string, Font font, int availableWidth, float avg, int wrapping) {
        int result;
        frag._length = result = FlowUtilities.getTextForSpace(string, font, availableWidth, avg, wrapping);
        FlowUtilities.setupFragment(frag, font, string);
        return result;
    }

    public static int getTextForSpace(String string, Font font, int availableWidth, float avg, int wrapping) {
        if (string.length() == 0) {
            return 0;
        }
        FontMetrics metrics = FlowUtilities.getFontMetrics((Font)font);
        BreakIterator breakItr = BreakIterator.getLineInstance();
        breakItr.setText(string);
        if ((double)avg == 0.0) {
            avg = metrics.getAverageCharWidth();
        }
        int firstBreak = breakItr.next();
        int winNL = string.indexOf("\r\n");
        int macNL = string.indexOf(13);
        int unixNL = string.indexOf(10);
        int min = wrapping == 0 ? firstBreak : 1;
        int MIN = min;
        if (macNL == winNL) {
            macNL = -1;
        }
        int max = string.length() + 1;
        if (winNL != -1) {
            max = Math.min(max, winNL);
            min = Math.min(min, winNL);
        }
        if (unixNL != -1) {
            max = Math.min(max, unixNL);
            min = Math.min(min, unixNL);
        }
        if (macNL != -1) {
            max = Math.min(max, macNL);
            min = Math.min(min, macNL);
        }
        int origMax = max;
        int guess = 0;
        int guessSize = 0;
        while (max - min > 1) {
            if ((guess += (int)((float)(availableWidth - guessSize) / avg)) >= max) {
                guess = max - 1;
            }
            if (guess <= min) {
                guess = min + 1;
            }
            if ((guessSize = FlowUtilities.getStringExtents2((String)string.substring((int)0, (int)guess), (Font)font).width) <= availableWidth) {
                min = guess;
                continue;
            }
            max = guess;
        }
        int result = string.length();
        switch (wrapping) {
            case 0: {
                if (min == string.length() || min == winNL || min == unixNL || min == macNL) {
                    result = min;
                    break;
                }
                if (max == origMax && FlowUtilities.getStringExtents2((String)string.substring((int)0, (int)max), (Font)font).width <= availableWidth) {
                    result = max;
                    break;
                }
                result = Math.max(MIN, breakItr.preceding(Math.min(max, string.length() - 1)));
                break;
            }
            case 1: {
                result = min == string.length() || min == winNL || min == unixNL || min == macNL ? min : (max == origMax && FlowUtilities.getStringExtents2((String)string.substring((int)0, (int)max), (Font)font).width <= availableWidth ? max : (breakItr.isBoundary(min) ? min : (breakItr.isBoundary(Math.min(max, string.length() - 1)) ? max : breakItr.preceding(Math.min(max, string.length() - 1)))));
                if (result > 0) break;
                result = min;
            }
        }
        return result;
    }

    public static int getTextInWidth(String string, Font font, int availableWidth, float avg) {
        if (string.length() == 0) {
            return 0;
        }
        int guess = 0;
        do {
            Dimension a = FlowUtilities.getTextExtents((String)string.substring(0, guess), (Font)font);
            if (a.width < availableWidth) continue;
            return guess;
        } while (++guess != string.length());
        return guess;
    }

    public static Dimension getStringExtents2(String s, Font f) {
        return new Dimension(FlowUtilities.getStringDimension((String)s, (Font)f));
    }

    static void setupFragment(TextFragmentBox frag, Font f, String s) {
        frag.setTextData(s.substring(0, frag._length));
        Dimension d = FlowUtilities.getStringExtents2(s.substring(0, frag._length), f);
        FontMetrics fm = FlowUtilities.getFontMetrics((Font)f);
        frag.setHeight(fm.getHeight());
        frag.setAscent(fm.getAscent() + fm.getLeading());
        frag._isLastCharWhitespace = frag._length > 0 && Character.isWhitespace(s.charAt(frag._length - 1));
        frag.setWidth(d.width);
    }
}

