/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout.table;

import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.ICSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.table.CSSTableCellLayout;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableInfo;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableInfoContext;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableItemInfo;
import org.eclipse.jst.pagedesigner.css2.value.Length;
import org.eclipse.jst.pagedesigner.utils.IntFlexArray;

public class TableCellInfo
extends TableItemInfo {
    int _rowSpan = 1;
    int _colSpan = 1;
    int _colIndex;
    int _rowIndex;
    int _cellWidth = 0;
    int _cellHeight = 0;

    public TableCellInfo(ICSSFigure childfigure) {
        super(childfigure);
    }

    public int getColSpan() {
        return this._colSpan;
    }

    public int getRowSpan() {
        return this._rowSpan;
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public int getColumnIndex() {
        return this._colIndex;
    }

    public Dimension getMinCWDimension() {
        return this.getFigure().getPreferredSize(this._cellWidth, this._cellHeight);
    }

    public Dimension getMaxCWDimension() {
        ICSSFigure figure = this.getFigure();
        LayoutManager layout = figure.getLayoutManager();
        if (layout instanceof CSSTableCellLayout) {
            Dimension d = ((CSSTableCellLayout)layout).getMaxContentWidthSize(figure, this._cellWidth, this._cellHeight);
            return d;
        }
        return this.getMinCWDimension();
    }

    public void calculateCellInfo(TableInfoContext context) {
        ICSSStyle style = this.getStyle();
        this._rowSpan = style.getRowSpan();
        this._colSpan = style.getColSpan();
        if (this._rowSpan <= 0) {
            this._rowSpan = 1;
        }
        if (this._colSpan <= 0) {
            this._colSpan = 1;
        }
        this._rowIndex = context.getCurrentRow();
        IntFlexArray array = context.getIntFlexArray();
        int currentCol = context.getCurrentCol();
        while (array.getAt(currentCol) > 0) {
            ++currentCol;
        }
        this._colIndex = currentCol;
        int i = 0;
        while (i < this._colSpan) {
            array.setAt(currentCol, this._rowSpan);
            ++i;
            ++currentCol;
        }
        context.setCurrentCol(currentCol);
    }

    public void calculateWidth(TableInfo tableInfo, int tablewidth) {
        ICSSStyle style = this.getFigure().getCSSStyle();
        if (style == null) {
            this._cellWidth = -1;
        } else {
            Object width = style.getStyleProperty("width");
            Length recommendedWidth = width instanceof Length ? (Length)width : null;
            int rw = 0;
            if (recommendedWidth == null || recommendedWidth.getValue() <= 0) {
                rw = 0;
            } else if (recommendedWidth.isPercentage()) {
                int colspan = this.getColSpan();
                int i = 0;
                while (i < colspan) {
                    tableInfo.setWidthPercentage(this.getColumnIndex() + i, recommendedWidth.getValue() / colspan);
                    ++i;
                }
            } else {
                rw = recommendedWidth.getValue();
                if (!style.isSizeIncludeBorderPadding()) {
                    rw += style.getBorderInsets().getWidth() + style.getPaddingInsets().getWidth();
                }
                if (this.getColSpan() == 1) {
                    tableInfo._widthSpecified[this.getColumnIndex()] = true;
                }
            }
            this._cellWidth = rw;
        }
    }

    public void calculateHeight(TableInfo tableInfo, int tableheight) {
        ICSSStyle style = this.getFigure().getCSSStyle();
        if (style == null) {
            this._cellHeight = -1;
        } else {
            Object height = style.getStyleProperty("height");
            Length recommendedHeight = height instanceof Length ? (Length)height : null;
            int rh = 0;
            if (recommendedHeight == null || recommendedHeight.getValue() <= 0) {
                rh = 0;
            } else {
                if (recommendedHeight.isPercentage()) {
                    int rowspan = this.getRowSpan();
                    int i = 0;
                    while (i < rowspan) {
                        tableInfo.setHeightPercentage(this.getRowIndex() + i, recommendedHeight.getValue() / rowspan);
                        ++i;
                    }
                } else {
                    rh = recommendedHeight.getValue();
                }
                if (!style.isSizeIncludeBorderPadding()) {
                    rh += style.getBorderInsets().getHeight() + style.getPaddingInsets().getHeight();
                }
            }
            this._cellHeight = rh;
        }
    }

    public int getHeight() {
        return this._cellHeight;
    }
}

