/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.style;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jst.pagedesigner.css2.CSSUtil;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.font.CSSFontManager;
import org.eclipse.jst.pagedesigner.css2.font.ICSSFont;
import org.eclipse.jst.pagedesigner.css2.font.ICSSFontManager;
import org.eclipse.jst.pagedesigner.css2.list.CounterHelper;
import org.eclipse.jst.pagedesigner.css2.list.CounterValueGenerator;
import org.eclipse.jst.pagedesigner.css2.list.ICounterValueGenerator;
import org.eclipse.jst.pagedesigner.css2.property.CSSMetaRegistry;
import org.eclipse.jst.pagedesigner.css2.property.ICSSPropertyMeta;
import org.eclipse.jst.pagedesigner.css2.style.DefaultStyle;
import org.eclipse.jst.pagedesigner.css2.style.IRangeSelectionProxy;
import org.eclipse.jst.pagedesigner.css2.value.Length;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class AbstractStyle
implements ICSSStyle {
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ID = "id";
    protected Element _element;
    private Map _cachedValues = new HashMap();
    private ICSSFont _font = null;
    private CSSStyleDeclaration _cache;
    private CSSStyleDeclaration _defaultCache;
    private boolean _cssDeclareWasSearched = false;
    private boolean _cssDefaultDeclareWasSearched = false;
    private Insets _borderInsets;
    private Insets _marginInsets;
    private Insets _paddingInsets;
    private ICSSStyle _parentStyle;
    private HashMap _counters = null;

    public Element getElement() {
        return this._element;
    }

    public AbstractStyle(Element element) {
        this._element = element;
    }

    public void reset() {
        this._cachedValues.clear();
        this._font = null;
        this._cache = null;
        this._defaultCache = null;
        this._cssDeclareWasSearched = false;
        this._cssDefaultDeclareWasSearched = false;
        this._paddingInsets = null;
        this._marginInsets = null;
        this._borderInsets = null;
    }

    public void setStyleProperty(String property, Object value) {
        this._cachedValues.put(property, value);
    }

    public Object getStyleProperty(String property) {
        Object value = this._cachedValues.get(property);
        if (value == null && (value = this.calculateProperty(property)) != null) {
            this._cachedValues.put(property, value);
        }
        return value;
    }

    protected CSSStyleDeclaration calculateDeclaration() {
        String name = this.getHtmlElement().getAttribute(ATTR_ID);
        if (name == null || name.length() == 0) {
            name = this.getHtmlElement().getAttribute(ATTR_NAME);
        }
        return CSSUtil.getCSSDeclaration(this.getHtmlElement(), name);
    }

    protected CSSStyleDeclaration calculateDefaultDeclaration() {
        return CSSUtil.getDefaultCSSDeclaration(this.getHtmlElement(), null);
    }

    public CSSStyleDeclaration getDeclaration() {
        if (!this._cssDeclareWasSearched) {
            this._cache = this.calculateDeclaration();
            this._cssDeclareWasSearched = true;
        }
        return this._cache;
    }

    public CSSStyleDeclaration getDefaultDeclaration() {
        if (!this._cssDefaultDeclareWasSearched) {
            this._defaultCache = this.calculateDefaultDeclaration();
            this._cssDefaultDeclareWasSearched = true;
        }
        return this._defaultCache;
    }

    public Object getHTMLelementInitValue(String propertyName) {
        ICSSPropertyMeta meta = this.getPropertyMeta(propertyName);
        if (meta != null) {
            Object obj = meta.getHTMLElementInitialValue(this._element, this.getHTMLTag(), propertyName);
            if (obj == null) {
                obj = meta.getInitialValue(propertyName, this);
            }
            return obj;
        }
        return ICSSPropertyMeta.NOT_SPECIFIED;
    }

    protected Object calculateProperty(String propertyName) {
        CSSValue value;
        ICSSPropertyMeta meta = this.getPropertyMeta(propertyName);
        Object result = null;
        CSSStyleDeclaration decl = this.getDeclaration();
        CSSValue cSSValue = value = decl == null ? null : decl.getPropertyCSSValue(propertyName);
        if (value == null) {
            if (meta != null && (result = meta.calculateHTMLAttributeOverride(this._element, this.getHTMLTag(), propertyName, this)) != null) {
                return result;
            }
            decl = this.getDefaultDeclaration();
        }
        CSSValue cSSValue2 = value = decl == null ? null : decl.getPropertyCSSValue(propertyName);
        if (value != null && value.getCssValueType() == 0) {
            result = this.getParentResultValue(meta, propertyName);
        } else if (value == null) {
            if (meta != null) {
                result = meta.calculateHTMLAttributeOverride(this._element, this.getHTMLTag(), propertyName, this);
            }
            if (result == null) {
                result = this.calculateLocalOverride(meta, propertyName);
            }
            if (result == null) {
                result = meta == null ? ICSSPropertyMeta.NOT_SPECIFIED : (meta.isInherited() ? this.getParentResultValue(meta, propertyName) : meta.getInitialValue(propertyName, this));
            }
        } else {
            result = this.calculateCSSValueResult(meta, value, propertyName);
        }
        return result;
    }

    protected String getHTMLTag() {
        return this._element.getTagName();
    }

    protected ICSSPropertyMeta getPropertyMeta(String propertyName) {
        return CSSMetaRegistry.getInstance().getMeta(propertyName);
    }

    protected Object calculateCSSValueResult(ICSSPropertyMeta meta, CSSValue value, String propertyName) {
        if (meta == null) {
            return ICSSPropertyMeta.NOT_SPECIFIED;
        }
        return meta.calculateCSSValueResult(value, propertyName, this);
    }

    protected Object calculateLocalOverride(ICSSPropertyMeta meta, String propertyName) {
        return null;
    }

    protected Object getParentResultValue(ICSSPropertyMeta meta, String propertyName) {
        ICSSStyle style = this.getParentStyle();
        return style.getStyleProperty(propertyName);
    }

    public void setParentStyle(ICSSStyle parentStyle) {
        this._parentStyle = parentStyle;
        this.reset();
    }

    public ICSSStyle getParentStyle() {
        if (this._parentStyle != null) {
            return this._parentStyle;
        }
        Node node = this._element.getParentNode();
        while (node instanceof Element && node instanceof INodeNotifier) {
            ICSSStyle parentStyle = (ICSSStyle)((INodeNotifier)node).getAdapterFor(ICSSStyle.class);
            if (parentStyle != null) {
                return parentStyle;
            }
            node = node.getParentNode();
        }
        return DefaultStyle.getInstance();
    }

    public ICSSFont getCSSFont() {
        if (this._font == null) {
            this._font = this.getFontManager().createFont(this);
        }
        return this._font;
    }

    private ICSSFontManager getFontManager() {
        return CSSFontManager.getInstance();
    }

    public void dispose() {
    }

    public Insets getMarginInsets() {
        if (this._marginInsets == null) {
            int top = this.getInsetProperty("margin-top");
            int left = this.getInsetProperty("margin-left");
            int bottom = this.getInsetProperty("margin-bottom");
            int right = this.getInsetProperty("margin-right");
            this._marginInsets = new Insets(top, left, bottom, right);
        }
        return this._marginInsets;
    }

    public Insets getPaddingInsets() {
        if (this._paddingInsets == null) {
            int top = this.getInsetProperty("padding-top") + 4;
            int left = this.getInsetProperty("padding-left") + 4;
            int bottom = this.getInsetProperty("padding-bottom") + 4;
            int right = this.getInsetProperty("padding-right") + 4;
            this._paddingInsets = new Insets(top, left, bottom, right);
        }
        return this._paddingInsets;
    }

    public Insets getBorderInsets() {
        if (this._borderInsets == null) {
            int top = this.getInsetProperty("border-top-width");
            int left = this.getInsetProperty("border-left-width");
            int bottom = this.getInsetProperty("border-bottom-width");
            int right = this.getInsetProperty("border-right-width");
            this._borderInsets = new Insets(top, left, bottom, right);
        }
        return this._borderInsets;
    }

    private int getInsetProperty(String propertyName) {
        Object obj = this.getStyleProperty(propertyName);
        if (obj instanceof Length) {
            Length l = (Length)obj;
            if (l.isPercentage()) {
                return 0;
            }
            return l.getValue();
        }
        return 0;
    }

    public boolean isAdapterForType(Object type) {
        return type == ICSSStyle.class;
    }

    public boolean isSizeIncludeBorderPadding() {
        String display = this.getDisplay();
        if ("table-cell".equalsIgnoreCase(display)) {
            return false;
        }
        String tag = this.getHTMLTag();
        return !"img".equalsIgnoreCase(tag);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    public Object getColor() {
        Object _color = null;
        if (_color == null && (_color = this.getStyleProperty("color")) == null) {
            _color = this.getStyleProperty("text");
        }
        return _color;
    }

    public Object getBackgroundColor() {
        Object _backgroundColor = null;
        if (_backgroundColor == null) {
            _backgroundColor = this.getStyleProperty("background-color");
        }
        return _backgroundColor;
    }

    public Element getHtmlElement() {
        return this._element;
    }

    public String getDisplay() {
        Object display = this.getStyleProperty("display");
        String displayStr = display == null ? "inline" : (display instanceof String ? (String)display : display.toString());
        if ("inline".equalsIgnoreCase(displayStr) && "table".equalsIgnoreCase(this.getHTMLTag())) {
            return "inline-table";
        }
        if ("inline".equalsIgnoreCase(displayStr)) {
            Object width = this.getStyleProperty("width");
            if (width instanceof Length) {
                return "inline-block";
            }
            Object height = this.getStyleProperty("height");
            if (height instanceof Length) {
                return "inline-block";
            }
            return displayStr;
        }
        return displayStr;
    }

    public Map getCounters() {
        if (this._counters == null) {
            this._counters = new HashMap();
            CounterHelper.processCounterReset(this, this._counters);
        }
        return this._counters;
    }

    public ICounterValueGenerator findCounter(String name, boolean must) {
        Map counters = this.getCounters();
        if (counters == null || !counters.containsKey(name)) {
            if (this.getParentStyle() != null && !(this.getParentStyle() instanceof DefaultStyle)) {
                return this.getParentStyle().findCounter(name, must);
            }
            if (must) {
                CounterValueGenerator counter = new CounterValueGenerator(name, null, null, this);
                counter.resetCount();
                counters.put(name, counter);
            }
        }
        return (ICounterValueGenerator)counters.get(name);
    }

    public void dumpDebugInfo(StringBuffer buffer) {
        if (this._cache != null) {
            buffer.append("cache:\n");
            buffer.append(this._cache.getCssText()).append("\n");
        }
        if (this._defaultCache != null) {
            buffer.append("default cache:\n");
            buffer.append(this._defaultCache.getCssText()).append("\n");
        }
    }

    public int getColSpan() {
        int colspan = DOMUtil.getIntAttributeIgnoreCase(this.getHtmlElement(), "colspan", 1);
        if (colspan < 0) {
            return 1;
        }
        return colspan;
    }

    public int getRowSpan() {
        int rowspan = DOMUtil.getIntAttributeIgnoreCase(this.getHtmlElement(), "rowspan", 1);
        if (rowspan < 0) {
            return 1;
        }
        return rowspan;
    }

    public boolean isInSelection() {
        IRangeSelectionProxy proxy = (IRangeSelectionProxy)this.getAdapter(IRangeSelectionProxy.class);
        if (proxy != null) {
            return proxy.isRangeSelected();
        }
        ICSSStyle parentStyle = this.getParentStyle();
        if (parentStyle != null) {
            return parentStyle.isInSelection();
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        INodeAdapter ret;
        if (this._element instanceof INodeNotifier && (ret = ((INodeNotifier)this._element).getAdapterFor((Object)adapter)) != null && adapter.isInstance(ret)) {
            return ret;
        }
        return null;
    }

    public void processCounters() {
        this._counters = null;
        CounterHelper.processCounterIncrement(this);
    }
}

