/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtmanager.converter.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.eclipse.jst.pagedesigner.converter.IDOMFactory;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.css2.style.ITagEditInfo;
import org.eclipse.jst.pagedesigner.dtmanager.converter.internal.DTHTMLOutputRenderer;
import org.eclipse.jst.pagedesigner.dtmanager.converter.internal.DTTagConverterContext;
import org.eclipse.jst.pagedesigner.dtmanager.converter.internal.DTTagConverterDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DTTagConverter
implements ITagConverter,
ITagEditInfo,
INodeAdapter,
IDOMFactory {
    private Element hostElement;
    private Element resultElement;
    private Image visualImage;
    private ImageDescriptor visualImageDescriptor;
    private IDOMDocument destDocument;
    private List childNodeList = Collections.EMPTY_LIST;
    private Map childVisualPositionMap = Collections.EMPTY_MAP;
    private List nonVisualChildElementList = Collections.EMPTY_LIST;
    private boolean isMultiLevel = false;
    private boolean isVisualByHTML = true;
    private boolean isWidget = false;
    private int mode;
    private int minHeight;
    private int minWidth;
    private boolean needBorderDecorator = false;
    private boolean needTableDecorator = false;

    public DTTagConverter(Element hostElement) {
        this.hostElement = hostElement;
    }

    public void convertRefresh(Object context) {
        this.childNodeList = new ArrayList();
        this.childVisualPositionMap = new HashMap();
        this.nonVisualChildElementList = new ArrayList();
        this.resultElement = new DTHTMLOutputRenderer().render(new DTTagConverterContext(this));
        new DTTagConverterDecorator().decorate(this);
        if (this.resultElement instanceof INodeNotifier) {
            ((INodeNotifier)this.resultElement).addAdapter((INodeAdapter)this);
        }
    }

    public void dispose() {
        if (this.visualImage != null) {
            this.visualImage.dispose();
        }
    }

    public List getChildModeList() {
        return this.childNodeList;
    }

    public ConvertPosition getChildVisualPosition(Node childModel) {
        return (ConvertPosition)this.childVisualPositionMap.get(childModel);
    }

    public Element getHostElement() {
        return this.hostElement;
    }

    public List getNonVisualChildren() {
        return this.nonVisualChildElementList;
    }

    public void setResultElement(Element resultElement) {
        this.resultElement = resultElement;
    }

    public Element getResultElement() {
        return this.resultElement;
    }

    public void setVisualImage(Image visualImage) {
        this.visualImage = visualImage;
    }

    public void setVisualImageDescriptor(ImageDescriptor imageDescriptor) {
        this.visualImageDescriptor = imageDescriptor;
    }

    public Image getVisualImage() {
        if (this.visualImage == null && this.visualImageDescriptor != null) {
            this.visualImage = this.visualImageDescriptor.createImage();
        }
        return this.visualImage;
    }

    public void setMultiLevel(boolean isMultiLevel) {
        this.isMultiLevel = isMultiLevel;
    }

    public boolean isMultiLevel() {
        return this.isMultiLevel;
    }

    public void setVisualByHTML(boolean isVisualByHTML) {
        this.isVisualByHTML = isVisualByHTML;
    }

    public boolean isVisualByHTML() {
        return this.isVisualByHTML;
    }

    public void setWidget(boolean isWidget) {
        this.isWidget = isWidget;
    }

    public boolean isWidget() {
        return this.isWidget;
    }

    public void setDestDocument(IDOMDocument destDocument) {
        this.destDocument = destDocument;
    }

    public IDOMDocument getDestDocument() {
        IDOMDocument document = null;
        document = this.destDocument != null ? this.destDocument : (IDOMDocument)this.hostElement.getOwnerDocument();
        return document;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinWidth(int minWidth) {
        this.minWidth = minWidth;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setNeedBorderDecorator(boolean needBorderDecorator) {
        this.needBorderDecorator = needBorderDecorator;
    }

    public boolean needBorderDecorator() {
        return this.needBorderDecorator;
    }

    public void setNeedTableDecorator(boolean needTableDecorator) {
        this.needTableDecorator = needTableDecorator;
    }

    public boolean needTableDecorator() {
        return this.needTableDecorator;
    }

    public boolean isAdapterForType(Object type) {
        return type == ITagEditInfo.class;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    public Element createElement(String tag) {
        return this.getDestDocument().createElement(tag);
    }

    public Text createText(String content) {
        return this.getDestDocument().createTextNode(content);
    }

    public void addChild(Node childNode, ConvertPosition position) {
        this.childNodeList.add(childNode);
        this.childVisualPositionMap.put(childNode, position);
    }

    public void copyChildren(Element srcElement, Element destElement) {
        int index = 0;
        NodeList childNodes = srcElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node curNode = childNodes.item(i);
            if (curNode.getNodeType() == 1 || curNode.getNodeType() == 3 || curNode.getNodeType() == 4) {
                this.addChild(curNode, new ConvertPosition(destElement, index++));
            }
            ++i;
        }
    }

    public void addNonVisualChildElement(Element childElement) {
        this.nonVisualChildElementList.add(childElement);
    }
}

