/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.customize.PaletteCustomizerDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteCustomizer;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteCustomizerDialog;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteRoot;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteItemManager;
import org.eclipse.jst.pagedesigner.editors.palette.impl.PaletteItemManager;
import org.eclipse.jst.pagedesigner.editors.palette.impl.TaglibPaletteDrawer;
import org.eclipse.jst.pagedesigner.utils.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class DesignerPaletteCustomizationsHelper {
    private static final String PREFS_TAGLIBHIDE_PREFIX = "hidden_taglib:";
    private static Logger _log = PDPlugin.getLogger(DesignerPaletteCustomizationsHelper.class);

    public static DesignerPaletteCustomizer getNewCustomizer() {
        return new DesignerPaletteCustomizer();
    }

    public static PaletteCustomizerDialog getNewCustomizerDialog(PaletteViewer paletteViewer, PaletteCustomizer paletteCustomizer) {
        return new DesignerPaletteCustomizerDialog(paletteViewer.getControl().getShell(), paletteCustomizer, paletteViewer.getPaletteRoot());
    }

    public static void save(DesignerPaletteRoot paletteRoot) {
        IPersistentPreferenceStore prefs = DesignerPaletteCustomizationsHelper.getPreferenceStore();
        for (PaletteEntry entry : paletteRoot.getChildren()) {
            if (!(entry instanceof TaglibPaletteDrawer)) continue;
            TaglibPaletteDrawer pd = (TaglibPaletteDrawer)entry;
            prefs.putValue(PREFS_TAGLIBHIDE_PREFIX + pd.getURI(), Boolean.toString(!pd.isVisible()));
        }
        PaletteItemManager.notifyPaletteItemManagersOfCustomizationsUpdate(paletteRoot.getPaletteManager());
    }

    public static void loadUserCustomizations(IPaletteItemManager paletteItemManager) {
        IPersistentPreferenceStore store = DesignerPaletteCustomizationsHelper.getPreferenceStore();
        for (TaglibPaletteDrawer tld : paletteItemManager.getAllCategories()) {
            if (!store.contains(PREFS_TAGLIBHIDE_PREFIX + tld.getURI())) continue;
            tld.setVisible(!store.getBoolean(PREFS_TAGLIBHIDE_PREFIX + tld.getURI()));
        }
    }

    public static void hideTaglibDrawer(TaglibPaletteDrawer taglibPaletteDrawer) {
        IPersistentPreferenceStore prefs = DesignerPaletteCustomizationsHelper.getPreferenceStore();
        taglibPaletteDrawer.setVisible(false);
        prefs.putValue(PREFS_TAGLIBHIDE_PREFIX + taglibPaletteDrawer.getURI(), Boolean.TRUE.toString());
        DesignerPaletteCustomizationsHelper.save((DesignerPaletteRoot)taglibPaletteDrawer.getParent());
    }

    private static IPersistentPreferenceStore getPreferenceStore() {
        return (IPersistentPreferenceStore)PDPlugin.getDefault().getPreferenceStore();
    }

    public static void exportCustomizations(IPaletteItemManager paletteItemManager, String filename) {
        Document document = XMLUtil.getDocumentBuilder().getDOMImplementation().createDocument(null, "palette-item", null);
        try {
            FileOutputStream ostream = null;
            int index = filename.lastIndexOf(File.separator);
            String foldername = filename.substring(0, index);
            File folder = new File(foldername);
            if (folder != null && !folder.exists()) {
                folder.mkdir();
            }
            ostream = new FileOutputStream(filename);
            for (TaglibPaletteDrawer category : paletteItemManager.getAllCategories()) {
                if (category == null) continue;
                Element categoryElement = document.createElement("category");
                categoryElement.setAttribute("id", category.getURI());
                categoryElement.setAttribute("hidden", Boolean.toString(!category.isVisible()));
                document.getDocumentElement().appendChild(categoryElement);
            }
            XMLUtil.serialize(document, ostream);
            ostream.close();
        }
        catch (IOException e) {
            _log.error("DesignerPaletteCustomizationsHelper.save.error.IOException", (Throwable)e);
        }
    }

    public static void importCustomizations(DesignerPaletteCustomizer customizer, String filename) {
        Element root;
        Document document = null;
        try {
            DocumentBuilder builder = XMLUtil.getDocumentBuilder();
            if (builder != null) {
                document = builder.parse(filename);
            } else {
                _log.error("DesignerPaletteCustomizationsHelper.importCustomizations.error.getDocumentBuilderFail");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            _log.error("DesignerPaletteCustomizationsHelper.importCustomizations.error.FileNotFoundException");
            document = null;
        }
        catch (IOException e) {
            _log.error("DesignerPaletteCustomizationsHelper.importCustomizations.error.IOException", e.toString(), (Throwable)e);
        }
        catch (SAXException e) {
            _log.error("DesignerPaletteCustomizationsHelper.importCustomizations.error.SAXException", e.toString(), (Throwable)e);
        }
        if (document != null && (root = document.getDocumentElement()) != null) {
            NodeList catetorylist = root.getChildNodes();
            int i = 0;
            int n = catetorylist.getLength();
            while (i < n) {
                Element categoryElement;
                Node childNode = catetorylist.item(i);
                if (childNode.getNodeType() == 1 && childNode.getNodeName().equals("category") && (categoryElement = (Element)childNode).hasAttribute("hidden")) {
                    boolean isHidden = Boolean.valueOf(categoryElement.getAttribute("hidden"));
                    String uri = categoryElement.getAttribute("id");
                    DesignerPaletteCustomizationsHelper.applyImport(customizer, uri, isHidden);
                }
                ++i;
            }
        }
    }

    private static void applyImport(DesignerPaletteCustomizer customizer, String uri, boolean isHidden) {
        for (Object o : customizer.getDesignerPaletteRoot().getChildren()) {
            TaglibPaletteDrawer pd;
            if (!(o instanceof TaglibPaletteDrawer) || !uri.equals((pd = (TaglibPaletteDrawer)((Object)o)).getURI())) continue;
            pd.setVisible(!isHidden);
            break;
        }
    }
}

