/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.figurehandler;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.CSSTextFigure;
import org.eclipse.jst.pagedesigner.css2.provider.ICSSTextProvider;
import org.eclipse.jst.pagedesigner.figurehandler.BRFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.DefaultFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.HiddenFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.IFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.ImgFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.InputFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.ObjectFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.SelectFigureHandler;
import org.eclipse.jst.pagedesigner.figurehandler.TextareaFigureHandler;
import org.eclipse.jst.pagedesigner.utils.HTMLUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class FigureFactory {
    private static void createFigureDeep(IFigure parentFigure, Node node) {
        if (node instanceof Element) {
            IFigureHandler handler = FigureFactory.createAndAdapt((Element)node);
            if (handler instanceof HiddenFigureHandler) {
                return;
            }
            CSSFigure figure = new CSSFigure();
            handler.updateFigure((Element)node, figure);
            parentFigure.add((IFigure)figure);
            if (!handler.isWidget()) {
                NodeList children = node.getChildNodes();
                int i = 0;
                int size = children.getLength();
                while (i < size) {
                    FigureFactory.createFigureDeep(figure, children.item(i));
                    ++i;
                }
            }
        } else if (node instanceof Text) {
            final String data = HTMLUtil.compactWhitespaces((Text)node, node.getNodeValue());
            if (data.trim().length() == 0) {
                return;
            }
            CSSTextFigure figure = new CSSTextFigure(new ICSSTextProvider(){

                public String getTextData() {
                    return data;
                }

                public int[] getSelectedRange() {
                    return null;
                }
            });
            parentFigure.add((IFigure)figure);
        }
    }

    public static IFigure updateDeepFigure(Element ele, Element old, CSSFigure figure) {
        FigureFactory.recursiveDisposeAndUnadapt(old);
        List figureChildren = figure.getChildren();
        int i = figureChildren.size() - 1;
        while (i >= 0) {
            figure.remove((IFigure)figureChildren.get(i));
            --i;
        }
        IFigureHandler handler = FigureFactory.createAndAdapt(ele);
        handler.updateFigure(ele, figure);
        if (!handler.isWidget()) {
            NodeList children = ele.getChildNodes();
            int i2 = 0;
            int size = children.getLength();
            while (i2 < size) {
                FigureFactory.createFigureDeep(figure, children.item(i2));
                ++i2;
            }
        }
        return figure;
    }

    public static void updateNonDeepFigure(Element ele, CSSFigure figure) {
        IFigureHandler handler = FigureFactory.getHandler(ele);
        if (handler == null) {
            handler = FigureFactory.createAndAdapt(ele);
        }
        handler.updateFigure(ele, figure);
    }

    static void recursiveDisposeAndUnadapt(Element ele) {
        FigureFactory.disposeAndUnadapt(ele);
        NodeList nl = ele.getChildNodes();
        int i = 0;
        int size = nl.getLength();
        while (i < size) {
            Node n = nl.item(i);
            if (n instanceof Element) {
                FigureFactory.recursiveDisposeAndUnadapt((Element)n);
            }
            ++i;
        }
    }

    static void disposeAndUnadapt(Element ele) {
        IFigureHandler handler = FigureFactory.getHandler(ele);
        if (handler != null) {
            handler.dispose();
            ((IDOMElement)ele).removeAdapter((INodeAdapter)handler);
        }
    }

    static IFigureHandler getHandler(Element ele) {
        if (ele instanceof IDOMElement) {
            IDOMElement xmlele = (IDOMElement)ele;
            return (IFigureHandler)xmlele.getAdapterFor(IFigureHandler.class);
        }
        return null;
    }

    static IFigureHandler createAndAdapt(Element ele) {
        IFigureHandler handler = FigureFactory.createFigureHandler(ele);
        if (ele instanceof IDOMElement) {
            ((IDOMElement)ele).addAdapter((INodeAdapter)handler);
        }
        return handler;
    }

    static IFigureHandler createFigureHandler(Element ele) {
        String tag = ele.getTagName();
        if ("input".equalsIgnoreCase(tag)) {
            return new InputFigureHandler();
        }
        if ("select".equalsIgnoreCase(tag)) {
            return new SelectFigureHandler();
        }
        if ("img".equalsIgnoreCase(tag)) {
            return new ImgFigureHandler();
        }
        if ("object".equalsIgnoreCase(tag)) {
            return new ObjectFigureHandler();
        }
        if ("textarea".equalsIgnoreCase(tag)) {
            return new TextareaFigureHandler();
        }
        if ("br".equalsIgnoreCase(tag)) {
            return new BRFigureHandler();
        }
        if (!HTMLUtil.isVisualHtmlElement(tag)) {
            return new HiddenFigureHandler(FigureFactory.getSharedHTMLImage(tag));
        }
        return new DefaultFigureHandler();
    }

    private static Image getSharedHTMLImage(String tag) {
        Image image = PDPlugin.getDefault().getImage("palette/HTML/small/HTML_" + tag.toUpperCase() + ".gif");
        ImageData imageData = image.getImageData();
        if (imageData.width < 16 || imageData.height < 16) {
            return PDPlugin.getDefault().getImage("palette/GENERIC/small/PD_Palette_Default.gif");
        }
        return image;
    }
}

