/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.ui.dialogfields;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldChangeListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IStringButtonAdapter;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ISupportTextValue;
import org.eclipse.jst.pagedesigner.meta.IAttributeDescriptor;
import org.eclipse.jst.pagedesigner.meta.IBindingHandler;
import org.eclipse.jst.pagedesigner.properties.attrgroup.IElementContextable;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class DialogFieldWrapper
implements DialogField,
ISupportTextValue,
IElementContextable {
    private DialogField _wrapped;
    private IDOMNode _ancester;
    private IDOMElement _element;
    private Button _databindingButton;
    private boolean _databindingEnabled;
    private Image _image;
    private Image _disabledImage;
    private IStringButtonAdapter _adapter;
    private String _uri;
    private String _tagName;
    private IAttributeDescriptor _attr;
    private IBindingHandler _handler;

    public DialogFieldWrapper(DialogField field, Image image, Image disabledImage, String uri, String tagName, IAttributeDescriptor attr, IBindingHandler handler) {
        if (!(field instanceof ISupportTextValue)) {
            throw new IllegalArgumentException("Field must be ISupportTextValue");
        }
        this._wrapped = field;
        this._image = image;
        this._disabledImage = disabledImage;
        this._uri = uri;
        this._tagName = tagName;
        this._attr = attr;
        this._handler = handler;
        this.setDatabindingPressedHandler(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field1) {
                Shell shell = field1.getLabelControl(null, null).getShell();
                DialogFieldWrapper wrapper = (DialogFieldWrapper)field1;
                String result = DialogFieldWrapper.this._handler.handleBinding(shell, wrapper.getAncester(), wrapper.getElement(), wrapper.getText());
                if (result != null) {
                    wrapper.setText(result);
                }
            }
        });
    }

    public void setDatabindingPressedHandler(IStringButtonAdapter adapter) {
        this._adapter = adapter;
        this.updateDatabindingControl();
    }

    public void setTextWithoutUpdate(String value) {
        ((ISupportTextValue)this._wrapped).setTextWithoutUpdate(value);
    }

    public String getText() {
        return ((ISupportTextValue)this._wrapped).getText();
    }

    public void setText(String value) {
        ((ISupportTextValue)this._wrapped).setText(value);
    }

    public void setElementContext(IDOMNode ancester, IDOMElement element) {
        if (this._wrapped instanceof IElementContextable) {
            ((IElementContextable)this._wrapped).setElementContext(ancester, element);
        }
        this._ancester = ancester;
        this._element = element;
        boolean bindingEnabled = this._handler.isEnabled(this._ancester, this._element, this._uri, this._tagName, this._attr);
        this.setDatabindingEnabled(bindingEnabled);
    }

    public Control[] doFillIntoGrid(FormToolkit toolkit, Composite parent, int nColumns) {
        Control[] wrappedControls = this._wrapped.doFillIntoGrid(toolkit, parent, nColumns - 1);
        Control[] result = new Control[wrappedControls.length];
        Control button = this.getDatabingingButton(toolkit, parent);
        button.setLayoutData((Object)this.gridDataForDatabindingButton(1));
        button.setVisible(false);
        System.arraycopy(wrappedControls, 0, result, 0, wrappedControls.length);
        result[result.length - 1] = this._databindingButton;
        return result;
    }

    private GridData gridDataForDatabindingButton(int span) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        gd.heightHint = 18;
        gd.widthHint = 18;
        return gd;
    }

    private Control getDatabingingButton(FormToolkit toolkit, Composite parent) {
        if (this._databindingButton == null) {
            Assert.isNotNull((Object)parent, (String)"uncreated control requested with composite null");
            if (toolkit != null) {
                this._databindingButton = toolkit.createButton(parent, "", 8);
                this._databindingButton.setImage(this.getImage());
            } else {
                this._databindingButton = new Button(parent, 8);
                this._databindingButton.setImage(this.getImage());
            }
            this._databindingButton.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (!DialogFieldWrapper.this._databindingButton.isEnabled() && DialogFieldWrapper.this.getDisabledImage() != null) {
                        Rectangle buttonBounds = DialogFieldWrapper.this._databindingButton.getBounds();
                        Rectangle imageBounds = DialogFieldWrapper.this.getDisabledImage().getBounds();
                        e.gc.drawImage(DialogFieldWrapper.this.getDisabledImage(), (buttonBounds.width - imageBounds.width) / 2, (buttonBounds.height - imageBounds.height) / 2);
                    }
                }
            });
            this._databindingButton.setEnabled(this.isEnabled() && this._databindingEnabled);
            this._databindingButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    DialogFieldWrapper.this.databindingControlPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    DialogFieldWrapper.this.databindingControlPressed();
                }
            });
        }
        return this._databindingButton;
    }

    private Image getImage() {
        return this._image;
    }

    private Image getDisabledImage() {
        return this._disabledImage;
    }

    public Control getLabelControl(FormToolkit _formToolkit, Composite parent) {
        return this._wrapped.getLabelControl(_formToolkit, parent);
    }

    public void setHyperLink(IHyperlinkListener listener) {
        this._wrapped.setHyperLink(listener);
    }

    public void setLabelText(String labeltext) {
        this._wrapped.setLabelText(labeltext);
    }

    public void setDialogFieldChangeListener(IDialogFieldChangeListener listener) {
        this._wrapped.setDialogFieldChangeListener(listener);
    }

    public void setDialogFieldApplyListener(IDialogFieldApplyListener listener) {
        this._wrapped.setDialogFieldApplyListener(listener);
    }

    public boolean setFocus() {
        return this._wrapped.setFocus();
    }

    public int getNumberOfControls() {
        return this._wrapped.getNumberOfControls() + 1;
    }

    public void setDatabindingEnabled(boolean enabled) {
        this._databindingEnabled = enabled;
        this.updateDatabindingControl();
    }

    public boolean isDatabindingEnabled() {
        return this._databindingEnabled;
    }

    public void setEnabled(boolean enabled) {
        this._wrapped.setEnabled(enabled);
        this.updateDatabindingControl();
    }

    private void updateDatabindingControl() {
        if (this._databindingButton != null && !this._databindingButton.isDisposed()) {
            this._databindingButton.setEnabled(this.isEnabled() && this._databindingEnabled && this._adapter != null);
            this._databindingButton.redraw();
        }
    }

    public boolean isEnabled() {
        return this._wrapped.isEnabled();
    }

    public Object getAttachedData(Object key) {
        return this._wrapped.getAttachedData(key);
    }

    public void putAttachedData(Object key, Object value) {
        this._wrapped.putAttachedData(key, value);
    }

    protected void databindingControlPressed() {
        if (this._adapter != null) {
            this._adapter.changeControlPressed((DialogField)this);
        }
    }

    public void handleGrabHorizontal() {
        this._wrapped.handleGrabHorizontal();
    }

    public IDOMNode getAncester() {
        return this._ancester;
    }

    public IDOMElement getElement() {
        return this._element;
    }

    public DialogField getWrappedDialogField() {
        return this._wrapped;
    }

    public boolean isRequired() {
        return this._wrapped.isRequired();
    }

    public void setToolTip(String toolTip) {
        this._wrapped.setToolTip(toolTip);
    }
}

