/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import java.util.Arrays;
import org.w3c.dom.Text;

public class HTMLUtil {
    public static final String[] HiddenTags = new String[]{"applet", "area", "base", "basefont", "head", "iframe", "isindex", "meta", "noembed", "noframes", "noscript", "script", "style", "title", "param"};

    public static boolean isHTMLWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\f' || ch == '\r' || ch == '\n' || ch == '\u200b';
    }

    public static boolean isHTMLWhitespaceString(String text) {
        int i = 0;
        int size = text.length();
        while (i < size) {
            if (!HTMLUtil.isHTMLWhitespace(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isVisualHtmlElement(String tag) {
        return !Arrays.asList(HiddenTags).contains(tag.toLowerCase());
    }

    public static String compactWhitespaces(Text textNode, String s) {
        char[] array = s.toCharArray();
        StringBuffer buffer = new StringBuffer(array.length);
        int posi = 0;
        int len = array.length;
        while (posi < len) {
            if (HTMLUtil.isHTMLWhitespace(array[posi])) {
                while (++posi < len && HTMLUtil.isHTMLWhitespace(array[posi])) {
                }
                buffer.append(' ');
                continue;
            }
            buffer.append(array[posi++]);
        }
        return buffer.toString();
    }
}

