/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.validation.caret;

import java.util.Arrays;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.EditValidateUtil;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.DefaultPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.w3c.dom.Node;

public class IETablePositionRule
extends DefaultPositionRule {
    private final String[] CONTAINER = new String[]{"thead", "tbody", "tfoot"};

    public IETablePositionRule(IPositionMediator mediator, ActionData actionData) {
        super(mediator, actionData);
    }

    public boolean hasEditableArea(Target target) {
        if (EditModelQuery.isChild("table", target.getNode(), true)) {
            if (target.getPart() == null) {
                return false;
            }
            Node node = target.getNode();
            String name = node.getLocalName();
            if (node.hasChildNodes()) {
                if (name != null && ("table".equalsIgnoreCase(name) || Arrays.asList(this.CONTAINER).contains(name.toLowerCase()) || "tr".equalsIgnoreCase(name))) {
                    List children = target.getPart().getChildren();
                    int i = 0;
                    int n = children.size();
                    while (i < n) {
                        if (this.hasEditableArea(new Target((EditPart)children.get(i)))) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
            } else if (!this.isEditable(new Target(node))) {
                return false;
            }
        }
        return super.hasEditableArea(target);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isInValidTable(Node container) {
        Node temp;
        int offset;
        List ancestors;
        String name;
        boolean result;
        block5: {
            result = false;
            try {
                if (!EditValidateUtil.validNode(container)) return result;
                if (EditModelQuery.isText(container)) {
                    container = container.getParentNode();
                }
                name = container.getLocalName();
                if (!EditModelQuery.isChild("table", container, true)) return result;
                ancestors = EditModelQuery.getAncestors(container, "table", true);
                temp = (Node)ancestors.remove((offset = ancestors.size()) - 1);
                if (temp != container) break block5;
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        result = this.checkValidTrTd(ancestors, container);
        if (result) return result;
        temp = (Node)ancestors.get(--offset - 1);
        name = temp.getNodeName();
        if (!Arrays.asList(this.CONTAINER).contains(name.toLowerCase())) return result;
        if (temp == container) {
            return true;
        }
        ancestors.remove(offset - 1);
        --offset;
        return this.checkValidTrTd(ancestors, container);
    }

    public boolean isEditable(Target target) {
        if (EditModelQuery.isChild("table", target.getNode(), false)) {
            List ancestors;
            if (this.isInValidTable(target.getNode()) && (ancestors = EditModelQuery.getAncestors(target.getNode(), "table", true)).size() >= 3) {
                if ("th".equalsIgnoreCase(((Node)ancestors.get(ancestors.size() - 3)).getNodeName()) || "td".equalsIgnoreCase(((Node)ancestors.get(ancestors.size() - 3)).getNodeName())) {
                    return true;
                }
                if (ancestors.size() >= 4 && ("th".equalsIgnoreCase(((Node)ancestors.get(ancestors.size() - 4)).getNodeName()) || "td".equalsIgnoreCase(((Node)ancestors.get(ancestors.size() - 4)).getNodeName()))) {
                    return true;
                }
            }
            return false;
        }
        return super.isEditable(target);
    }

    private boolean checkValidTrTd(List ancestors, Node node) {
        int offset = ancestors.size();
        if ("tr".equalsIgnoreCase(((Node)ancestors.get(offset - 1)).getLocalName())) {
            if (ancestors.get(offset - 1) == node) {
                return true;
            }
            if ("th".equalsIgnoreCase(((Node)ancestors.get(offset - 2)).getLocalName()) || "td".equalsIgnoreCase(((Node)ancestors.get(offset - 2)).getLocalName())) {
                return true;
            }
        }
        return false;
    }
}

